/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;

public class MergeFilters
implements Rule<FilterNode> {
    private static final Capture<FilterNode> CHILD = Capture.newCapture();
    private static final Pattern<FilterNode> PATTERN = Patterns.filter().with(Patterns.source().matching(Patterns.filter().capturedAs(CHILD)));

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode parent, Captures captures, Rule.Context context) {
        FilterNode child = (FilterNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new FilterNode(parent.getId(), child.getSource(), ExpressionUtils.combineConjuncts(child.getPredicate(), parent.getPredicate())));
    }
}

