/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TopNNode;
import java.util.List;

public class MergeLimitOverProjectWithSort
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<SortNode> SORT = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT).matching(ProjectNode::isIdentity).with(Patterns.source().matching(Patterns.sort().capturedAs(SORT)))));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode project = (ProjectNode)captures.get(PROJECT);
        SortNode sort = (SortNode)captures.get(SORT);
        return Rule.Result.ofPlanNode(project.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new TopNNode(parent.getId(), sort.getSource(), parent.getCount(), sort.getOrderingScheme(), parent.isPartial() ? TopNNode.Step.PARTIAL : TopNNode.Step.SINGLE))));
    }
}

