/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.DistinctLimitNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;

public class MergeLimitWithDistinct
implements Rule<LimitNode> {
    private static final Capture<AggregationNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.aggregation().capturedAs(CHILD).matching(AggregationNode::producesDistinctRows)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        AggregationNode child = (AggregationNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new DistinctLimitNode(parent.getId(), child.getSource(), parent.getCount(), false, child.getGroupingKeys(), child.getHashSymbol()));
    }
}

