/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;

public class MergeLimits
implements Rule<LimitNode> {
    private static final Capture<LimitNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.limit().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        LimitNode child = (LimitNode)captures.get(CHILD);
        return Rule.Result.ofPlanNode(new LimitNode(parent.getId(), child.getSource(), Math.min(parent.getCount(), child.getCount()), parent.isPartial()));
    }
}

