/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.tree.Expression;
import java.util.Set;
import java.util.stream.Stream;

public class PruneAggregationSourceColumns
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode aggregationNode, Captures captures, Rule.Context context) {
        Set requiredInputs = (Set)Streams.concat((Stream[])new Stream[]{aggregationNode.getGroupingKeys().stream(), aggregationNode.getHashSymbol().map(Stream::of).orElse(Stream.empty()), aggregationNode.getAggregations().values().stream().flatMap(PruneAggregationSourceColumns::getAggregationInputs)}).collect(ImmutableSet.toImmutableSet());
        return Util.restrictChildOutputs(context.getIdAllocator(), aggregationNode, requiredInputs).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }

    private static Stream<Symbol> getAggregationInputs(AggregationNode.Aggregation aggregation) {
        return Streams.concat((Stream[])new Stream[]{SymbolsExtractor.extractUnique((Expression)aggregation.getCall()).stream(), aggregation.getMask().map(Stream::of).orElse(Stream.empty())});
    }
}

