/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.tree.FunctionCall;
import java.util.Map;
import java.util.Objects;

public class PruneOrderByInAggregation
implements Rule<AggregationNode> {
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation();
    private final FunctionRegistry functionRegistry;

    public PruneOrderByInAggregation(FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode node, Captures captures, Rule.Context context) {
        if (!node.hasOrderings()) {
            return Rule.Result.empty();
        }
        boolean anyRewritten = false;
        ImmutableMap.Builder aggregations = ImmutableMap.builder();
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!aggregation.getCall().getOrderBy().isPresent()) {
                aggregations.put(entry);
                continue;
            }
            if (this.functionRegistry.getAggregateFunctionImplementation(aggregation.getSignature()).isOrderSensitive()) {
                aggregations.put(entry);
                continue;
            }
            anyRewritten = true;
            FunctionCall rewritten = new FunctionCall(aggregation.getCall().getName(), aggregation.getCall().isDistinct(), aggregation.getCall().getArguments(), aggregation.getCall().getFilter());
            aggregations.put((Object)entry.getKey(), (Object)new AggregationNode.Aggregation(rewritten, aggregation.getSignature(), aggregation.getMask()));
        }
        if (!anyRewritten) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new AggregationNode(node.getId(), node.getSource(), (Map<Symbol, AggregationNode.Aggregation>)aggregations.build(), node.getGroupingSets(), node.getPreGroupedSymbols(), node.getStep(), node.getHashSymbol(), node.getGroupIdSymbol()));
    }
}

