/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.util.MoreLists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PruneValuesColumns
extends ProjectOffPushDownRule<ValuesNode> {
    public PruneValuesColumns() {
        super(Patterns.values());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, ValuesNode valuesNode, Set<Symbol> referencedOutputs) {
        List<Symbol> newOutputs = MoreLists.filteredCopy(valuesNode.getOutputSymbols(), referencedOutputs::contains);
        int[] mapping = new int[newOutputs.size()];
        for (int i = 0; i < mapping.length; ++i) {
            mapping[i] = valuesNode.getOutputSymbols().indexOf(newOutputs.get(i));
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (List<Expression> row : valuesNode.getRows()) {
            rowsBuilder.add(Arrays.stream(mapping).mapToObj(row::get).collect(Collectors.toList()));
        }
        return Optional.of(new ValuesNode(valuesNode.getId(), newOutputs, (List<List<Expression>>)rowsBuilder.build()));
    }
}

