/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.prestosql.sql.planner.iterative.rule.Util;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.WindowNode;
import io.prestosql.sql.tree.Expression;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PruneWindowColumns
extends ProjectOffPushDownRule<WindowNode> {
    public PruneWindowColumns() {
        super(Patterns.window());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(PlanNodeIdAllocator idAllocator, WindowNode windowNode, Set<Symbol> referencedOutputs) {
        Map referencedFunctions = Maps.filterKeys(windowNode.getWindowFunctions(), referencedOutputs::contains);
        if (referencedFunctions.isEmpty()) {
            return Optional.of(windowNode.getSource());
        }
        ImmutableSet.Builder referencedInputs = ImmutableSet.builder().addAll(windowNode.getSource().getOutputSymbols().stream().filter(referencedOutputs::contains).iterator()).addAll(windowNode.getPartitionBy());
        windowNode.getOrderingScheme().ifPresent(orderingScheme -> orderingScheme.getOrderBy().forEach(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0)));
        windowNode.getHashSymbol().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        for (WindowNode.Function windowFunction : referencedFunctions.values()) {
            referencedInputs.addAll(SymbolsExtractor.extractUnique((Expression)windowFunction.getFunctionCall()));
            windowFunction.getFrame().getStartValue().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
            windowFunction.getFrame().getEndValue().ifPresent(arg_0 -> ((ImmutableSet.Builder)referencedInputs).add(arg_0));
        }
        WindowNode prunedWindowNode = new WindowNode(windowNode.getId(), Util.restrictOutputs(idAllocator, windowNode.getSource(), (Set<Symbol>)referencedInputs.build()).orElse(windowNode.getSource()), windowNode.getSpecification(), referencedFunctions, windowNode.getHashSymbol(), windowNode.getPrePartitionedInputs(), windowNode.getPreSortedOrderPrefix());
        if (((PlanNode)prunedWindowNode).getOutputSymbols().size() == windowNode.getOutputSymbols().size()) {
            return Optional.empty();
        }
        return Optional.of(prunedWindowNode);
    }
}

