/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.ExpressionRewriter;
import io.prestosql.sql.tree.ExpressionTreeRewriter;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.NotExpression;
import java.util.List;

public class PushDownNegationsExpressionRewriter {
    public static Expression pushDownNegations(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new Visitor(), (Expression)expression);
    }

    private PushDownNegationsExpressionRewriter() {
    }

    private static class Visitor
    extends ExpressionRewriter<Void> {
        private Visitor() {
        }

        public Expression rewriteNotExpression(NotExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            if (node.getValue() instanceof LogicalBinaryExpression) {
                LogicalBinaryExpression child = (LogicalBinaryExpression)node.getValue();
                List<Expression> predicates = ExpressionUtils.extractPredicates(child);
                List negatedPredicates = (List)predicates.stream().map(predicate -> treeRewriter.rewrite((Expression)new NotExpression(predicate), (Object)context)).collect(ImmutableList.toImmutableList());
                return ExpressionUtils.combinePredicates(child.getOperator().flip(), negatedPredicates);
            }
            if (node.getValue() instanceof ComparisonExpression && ((ComparisonExpression)node.getValue()).getOperator() != ComparisonExpression.Operator.IS_DISTINCT_FROM) {
                ComparisonExpression child = (ComparisonExpression)node.getValue();
                return new ComparisonExpression(child.getOperator().negate(), treeRewriter.rewrite(child.getLeft(), (Object)context), treeRewriter.rewrite(child.getRight(), (Object)context));
            }
            if (node.getValue() instanceof NotExpression) {
                NotExpression child = (NotExpression)node.getValue();
                return treeRewriter.rewrite(child.getValue(), (Object)context);
            }
            return new NotExpression(treeRewriter.rewrite(node.getValue(), (Object)context));
        }
    }
}

