/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableHandle;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;

public class PushLimitIntoTableScan
implements Rule<LimitNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)));
    private final Metadata metadata;

    public PushLimitIntoTableScan(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode limit, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        return this.metadata.applyLimit(context.getSession(), tableScan.getTable(), limit.getCount()).map(result -> {
            PlanNode node = new TableScanNode(tableScan.getId(), (TableHandle)result.getHandle(), tableScan.getOutputSymbols(), tableScan.getAssignments(), tableScan.getEnforcedConstraint());
            if (!result.isLimitGuaranteed()) {
                node = new LimitNode(limit.getId(), node, limit.getCount(), limit.isPartial());
            }
            return Rule.Result.ofPlanNode(node);
        }).orElseGet(Rule.Result::empty);
    }
}

