/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.List;

public class PushLimitThroughOuterJoin
implements Rule<LimitNode> {
    private static final Capture<JoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.join().with(Patterns.Join.type().matching(type -> type == JoinNode.Type.LEFT || type == JoinNode.Type.RIGHT)).capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        JoinNode joinNode = (JoinNode)captures.get(CHILD);
        PlanNode left = joinNode.getLeft();
        PlanNode right = joinNode.getRight();
        if (joinNode.getType() == JoinNode.Type.LEFT && !PushLimitThroughOuterJoin.isLimited(left, context.getLookup(), parent.getCount())) {
            return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)new LimitNode(context.getIdAllocator().getNextId(), left, parent.getCount(), true), (Object)right)))));
        }
        if (joinNode.getType() == JoinNode.Type.RIGHT && !PushLimitThroughOuterJoin.isLimited(right, context.getLookup(), parent.getCount())) {
            return Rule.Result.ofPlanNode(parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)joinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)left, (Object)new LimitNode(context.getIdAllocator().getNextId(), right, parent.getCount(), true))))));
        }
        return Rule.Result.empty();
    }

    private static boolean isLimited(PlanNode node, Lookup lookup, long limit) {
        Range<Long> cardinality = QueryCardinalityUtil.extractCardinality(node, lookup);
        return cardinality.hasUpperBound() && (Long)cardinality.upperEndpoint() <= limit;
    }
}

