/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.prestosql.matching.Capture;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.ExpressionSymbolInliner;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.UnionNode;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushProjectionThroughUnion
implements Rule<ProjectNode> {
    private static final Capture<UnionNode> CHILD = Capture.newCapture();
    private static final Pattern<ProjectNode> PATTERN = Patterns.project().with(Patterns.source().matching(Patterns.union().capturedAs(CHILD)));

    @Override
    public Pattern<ProjectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(ProjectNode parent, Captures captures, Rule.Context context) {
        UnionNode source = (UnionNode)captures.get(CHILD);
        List<Symbol> outputLayout = parent.getOutputSymbols();
        ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
        ImmutableList.Builder outputSources = ImmutableList.builder();
        for (int i = 0; i < source.getSources().size(); ++i) {
            Map<Symbol, SymbolReference> outputToInput = source.sourceSymbolMap(i);
            Assignments.Builder assignments = Assignments.builder();
            HashMap<Symbol, Symbol> projectSymbolMapping = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, Expression> entry : parent.getAssignments().entrySet()) {
                Expression translatedExpression = ExpressionSymbolInliner.inlineSymbols(outputToInput, entry.getValue());
                Type type = context.getSymbolAllocator().getTypes().get(entry.getKey());
                Symbol symbol2 = context.getSymbolAllocator().newSymbol(translatedExpression, type);
                assignments.put(symbol2, translatedExpression);
                projectSymbolMapping.put(entry.getKey(), symbol2);
            }
            outputSources.add((Object)new ProjectNode(context.getIdAllocator().getNextId(), source.getSources().get(i), assignments.build()));
            outputLayout.forEach(symbol -> mappings.put(symbol, projectSymbolMapping.get(symbol)));
        }
        return Rule.Result.ofPlanNode(new UnionNode(parent.getId(), (List<PlanNode>)outputSources.build(), (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet())));
    }
}

