/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.plan.LateralJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;

public class RemoveUnreferencedScalarLateralNodes
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Patterns.LateralJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode input = lateralJoinNode.getInput();
        PlanNode subquery = lateralJoinNode.getSubquery();
        if (this.isUnreferencedScalar(input, context.getLookup())) {
            return Rule.Result.ofPlanNode(subquery);
        }
        if (this.isUnreferencedScalar(subquery, context.getLookup())) {
            return Rule.Result.ofPlanNode(input);
        }
        return Rule.Result.empty();
    }

    private boolean isUnreferencedScalar(PlanNode planNode, Lookup lookup) {
        return planNode.getOutputSymbols().isEmpty() && QueryCardinalityUtil.isScalar(planNode, lookup);
    }
}

