/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.ExpressionUtils;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeDecorrelator;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LateralJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Optional;

public class TransformCorrelatedLateralJoinToJoin
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.nonEmpty(Patterns.LateralJoin.correlation()));

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = lateralJoinNode.getSubquery();
        PlanNodeDecorrelator planNodeDecorrelator = new PlanNodeDecorrelator(context.getIdAllocator(), context.getLookup());
        Optional<PlanNodeDecorrelator.DecorrelatedNode> decorrelatedNodeOptional = planNodeDecorrelator.decorrelateFilters(subquery, lateralJoinNode.getCorrelation());
        return decorrelatedNodeOptional.map(decorrelatedNode -> {
            Expression joinFilter = ExpressionUtils.combineConjuncts(decorrelatedNode.getCorrelatedPredicates().orElse((Expression)BooleanLiteral.TRUE_LITERAL), lateralJoinNode.getFilter());
            return Rule.Result.ofPlanNode(new JoinNode(context.getIdAllocator().getNextId(), lateralJoinNode.getType().toJoinNodeType(), lateralJoinNode.getInput(), decorrelatedNode.getNode(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), lateralJoinNode.getOutputSymbols(), joinFilter.equals((Object)BooleanLiteral.TRUE_LITERAL) ? Optional.empty() : Optional.of(joinFilter), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        }).orElseGet(Rule.Result::empty);
    }
}

