/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.optimizations.QueryCardinalityUtil;
import io.prestosql.sql.planner.optimizations.ScalarAggregationToJoinRewriter;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.LateralJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.util.MorePredicates;
import java.util.Objects;
import java.util.Optional;

public class TransformCorrelatedScalarAggregationToJoin
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.nonEmpty(Patterns.LateralJoin.correlation())).with(Patterns.LateralJoin.filter().equalTo((Object)BooleanLiteral.TRUE_LITERAL));
    private final FunctionRegistry functionRegistry;

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    public TransformCorrelatedScalarAggregationToJoin(FunctionRegistry functionRegistry) {
        this.functionRegistry = Objects.requireNonNull(functionRegistry, "functionRegistry is null");
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        PlanNode subquery = lateralJoinNode.getSubquery();
        if (!QueryCardinalityUtil.isScalar(subquery, context.getLookup())) {
            return Rule.Result.empty();
        }
        Optional<AggregationNode> aggregation = TransformCorrelatedScalarAggregationToJoin.findAggregation(subquery, context.getLookup());
        if (!aggregation.isPresent() || !aggregation.get().getGroupingKeys().isEmpty()) {
            return Rule.Result.empty();
        }
        ScalarAggregationToJoinRewriter rewriter = new ScalarAggregationToJoinRewriter(this.functionRegistry, context.getSymbolAllocator(), context.getIdAllocator(), context.getLookup());
        PlanNode rewrittenNode = rewriter.rewriteScalarAggregation(lateralJoinNode, aggregation.get());
        if (rewrittenNode instanceof LateralJoinNode) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(rewrittenNode);
    }

    private static Optional<AggregationNode> findAggregation(PlanNode rootNode, Lookup lookup) {
        return PlanNodeSearcher.searchFrom(rootNode, lookup).where(AggregationNode.class::isInstance).recurseOnlyWhen(MorePredicates.isInstanceOfAny(ProjectNode.class, EnforceSingleRowNode.class)).findFirst();
    }
}

