/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.LateralJoinNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Optional;

public class TransformUncorrelatedLateralToJoin
implements Rule<LateralJoinNode> {
    private static final Pattern<LateralJoinNode> PATTERN = Patterns.lateralJoin().with(Pattern.empty(Patterns.LateralJoin.correlation()));

    @Override
    public Pattern<LateralJoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LateralJoinNode lateralJoinNode, Captures captures, Rule.Context context) {
        return Rule.Result.ofPlanNode(new JoinNode(context.getIdAllocator().getNextId(), lateralJoinNode.getType().toJoinNodeType(), lateralJoinNode.getInput(), lateralJoinNode.getSubquery(), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.builder().addAll(lateralJoinNode.getInput().getOutputSymbols()).addAll(lateralJoinNode.getSubquery().getOutputSymbols()).build(), this.filter(lateralJoinNode.getFilter()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    private Optional<Expression> filter(Expression lateralJoinFilter) {
        if (lateralJoinFilter.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Optional.empty();
        }
        return Optional.of(lateralJoinFilter);
    }
}

