/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableProperties;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.DiscretePredicates;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.DeterminismEvaluator;
import io.prestosql.sql.planner.LiteralEncoder;
import io.prestosql.sql.planner.PlanNodeIdAllocator;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.optimizations.PlanOptimizer;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.MarkDistinctNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.SimplePlanRewriter;
import io.prestosql.sql.planner.plan.SortNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class MetadataQueryOptimizer
implements PlanOptimizer {
    private static final Set<String> ALLOWED_FUNCTIONS = ImmutableSet.of((Object)"max", (Object)"min", (Object)"approx_distinct");
    private final Metadata metadata;
    private final LiteralEncoder literalEncoder;

    public MetadataQueryOptimizer(Metadata metadata) {
        Objects.requireNonNull(metadata, "metadata is null");
        this.metadata = metadata;
        this.literalEncoder = new LiteralEncoder(metadata.getBlockEncodingSerde());
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, WarningCollector warningCollector) {
        if (!SystemSessionProperties.isOptimizeMetadataQueries(session)) {
            return plan;
        }
        return SimplePlanRewriter.rewriteWith(new Optimizer(session, this.metadata, this.literalEncoder, idAllocator), plan, null);
    }

    private static class Replacer
    extends SimplePlanRewriter<Void> {
        private final ValuesNode replacement;

        private Replacer(ValuesNode replacement) {
            this.replacement = replacement;
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            return this.replacement;
        }
    }

    private static class Optimizer
    extends SimplePlanRewriter<Void> {
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;
        private final Metadata metadata;
        private final LiteralEncoder literalEncoder;

        private Optimizer(Session session, Metadata metadata, LiteralEncoder literalEncoder, PlanNodeIdAllocator idAllocator) {
            this.session = session;
            this.metadata = metadata;
            this.literalEncoder = literalEncoder;
            this.idAllocator = idAllocator;
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            for (AggregationNode.Aggregation aggregation : node.getAggregations().values()) {
                if (ALLOWED_FUNCTIONS.contains(aggregation.getCall().getName().toString()) || aggregation.getCall().isDistinct()) continue;
                return context.defaultRewrite(node);
            }
            Optional<TableScanNode> result = Optimizer.findTableScan(node.getSource());
            if (!result.isPresent()) {
                return context.defaultRewrite(node);
            }
            TableScanNode tableScan = result.get();
            ImmutableMap.Builder typesBuilder = ImmutableMap.builder();
            ImmutableMap.Builder columnBuilder = ImmutableMap.builder();
            List<Symbol> inputs = tableScan.getOutputSymbols();
            for (Symbol symbol : inputs) {
                ColumnHandle column = tableScan.getAssignments().get(symbol);
                ColumnMetadata columnMetadata = this.metadata.getColumnMetadata(this.session, tableScan.getTable(), column);
                typesBuilder.put((Object)symbol, (Object)columnMetadata.getType());
                columnBuilder.put((Object)symbol, (Object)column);
            }
            ImmutableMap columns = columnBuilder.build();
            ImmutableMap types = typesBuilder.build();
            TableProperties layout = this.metadata.getTableProperties(this.session, tableScan.getTable());
            if (!layout.getDiscretePredicates().isPresent()) {
                return context.defaultRewrite(node);
            }
            DiscretePredicates predicates = layout.getDiscretePredicates().get();
            if (!predicates.getColumns().containsAll(columns.values())) {
                return context.defaultRewrite(node);
            }
            ImmutableList.Builder rowsBuilder = ImmutableList.builder();
            for (TupleDomain domain : predicates.getPredicates()) {
                if (domain.isNone()) continue;
                Map entries = (Map)TupleDomain.extractFixedValues((TupleDomain)domain).get();
                ImmutableList.Builder rowBuilder = ImmutableList.builder();
                for (Symbol input : inputs) {
                    ColumnHandle column = (ColumnHandle)columns.get(input);
                    Type type = (Type)types.get(input);
                    NullableValue value = (NullableValue)entries.get(column);
                    if (value == null) {
                        return context.defaultRewrite(node);
                    }
                    rowBuilder.add((Object)this.literalEncoder.toExpression(value.getValue(), type));
                }
                rowsBuilder.add((Object)rowBuilder.build());
            }
            ValuesNode valuesNode = new ValuesNode(this.idAllocator.getNextId(), inputs, (List<List<Expression>>)rowsBuilder.build());
            return SimplePlanRewriter.rewriteWith(new Replacer(valuesNode), node);
        }

        private static Optional<TableScanNode> findTableScan(PlanNode source) {
            while (true) {
                if (source instanceof MarkDistinctNode || source instanceof FilterNode || source instanceof LimitNode || source instanceof TopNNode || source instanceof SortNode) {
                    source = source.getSources().get(0);
                    continue;
                }
                if (!(source instanceof ProjectNode)) break;
                ProjectNode project = (ProjectNode)source;
                if (!Iterables.all(project.getAssignments().getExpressions(), DeterminismEvaluator::isDeterministic)) {
                    return Optional.empty();
                }
                source = project.getSource();
            }
            if (source instanceof TableScanNode) {
                return Optional.of((TableScanNode)source);
            }
            return Optional.empty();
        }
    }
}

