/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import io.prestosql.sql.planner.iterative.GroupReference;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.EnforceSingleRowNode;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.OffsetNode;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.ProjectNode;
import io.prestosql.sql.planner.plan.TopNNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import java.util.Objects;

public final class QueryCardinalityUtil {
    private QueryCardinalityUtil() {
    }

    public static boolean isScalar(PlanNode node) {
        return QueryCardinalityUtil.isScalar(node, Lookup.noLookup());
    }

    public static boolean isScalar(PlanNode node, Lookup lookup) {
        return Range.singleton((Comparable)Long.valueOf(1L)).encloses(QueryCardinalityUtil.extractCardinality(node, lookup));
    }

    public static boolean isAtMostScalar(PlanNode node) {
        return QueryCardinalityUtil.isAtMostScalar(node, Lookup.noLookup());
    }

    public static boolean isAtMostScalar(PlanNode node, Lookup lookup) {
        return QueryCardinalityUtil.isAtMost(node, lookup, 1L);
    }

    private static boolean isAtMost(PlanNode node, Lookup lookup, long maxCardinality) {
        return Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(maxCardinality)).encloses(QueryCardinalityUtil.extractCardinality(node, lookup));
    }

    public static Range<Long> extractCardinality(PlanNode node) {
        return QueryCardinalityUtil.extractCardinality(node, Lookup.noLookup());
    }

    public static Range<Long> extractCardinality(PlanNode node, Lookup lookup) {
        return node.accept(new CardinalityExtractorPlanVisitor(lookup), null);
    }

    private static final class CardinalityExtractorPlanVisitor
    extends PlanVisitor<Range<Long>, Void> {
        private final Lookup lookup;

        public CardinalityExtractorPlanVisitor(Lookup lookup) {
            this.lookup = Objects.requireNonNull(lookup, "lookup is null");
        }

        @Override
        protected Range<Long> visitPlan(PlanNode node, Void context) {
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitGroupReference(GroupReference node, Void context) {
            return this.lookup.resolve(node).accept(this, context);
        }

        @Override
        public Range<Long> visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return Range.singleton((Comparable)Long.valueOf(1L));
        }

        @Override
        public Range<Long> visitAggregation(AggregationNode node, Void context) {
            if (node.hasEmptyGroupingSet()) {
                return Range.singleton((Comparable)Long.valueOf(1L));
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitExchange(ExchangeNode node, Void context) {
            if (node.getSources().size() == 1) {
                return ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, null);
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitProject(ProjectNode node, Void context) {
            return node.getSource().accept(this, null);
        }

        @Override
        public Range<Long> visitFilter(FilterNode node, Void context) {
            Range<Long> sourceCardinalityRange = node.getSource().accept(this, null);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(0L), (Comparable)sourceCardinalityRange.upperEndpoint());
            }
            return Range.atLeast((Comparable)Long.valueOf(0L));
        }

        @Override
        public Range<Long> visitValues(ValuesNode node, Void context) {
            return Range.singleton((Comparable)Long.valueOf(node.getRows().size()));
        }

        @Override
        public Range<Long> visitOffset(OffsetNode node, Void context) {
            Range<Long> sourceCardinalityRange = node.getSource().accept(this, null);
            long lower = Math.max((Long)sourceCardinalityRange.lowerEndpoint() - node.getCount(), 0L);
            if (sourceCardinalityRange.hasUpperBound()) {
                return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(Math.max((Long)sourceCardinalityRange.upperEndpoint() - node.getCount(), 0L)));
            }
            return Range.atLeast((Comparable)Long.valueOf(lower));
        }

        @Override
        public Range<Long> visitLimit(LimitNode node, Void context) {
            return this.applyLimit(node.getSource(), node.getCount());
        }

        @Override
        public Range<Long> visitTopN(TopNNode node, Void context) {
            return this.applyLimit(node.getSource(), node.getCount());
        }

        private Range<Long> applyLimit(PlanNode source, long limit) {
            Range<Long> sourceCardinalityRange = source.accept(this, null);
            if (sourceCardinalityRange.hasUpperBound()) {
                limit = Math.min((Long)sourceCardinalityRange.upperEndpoint(), limit);
            }
            long lower = Math.min(limit, (Long)sourceCardinalityRange.lowerEndpoint());
            return Range.closed((Comparable)Long.valueOf(lower), (Comparable)Long.valueOf(limit));
        }
    }
}

