/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.optimizations;

import io.prestosql.sql.planner.SymbolsExtractor;
import io.prestosql.sql.planner.plan.WindowNode;
import java.util.Collection;

public final class WindowNodeUtil {
    private WindowNodeUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean dependsOn(WindowNode parent, WindowNode child) {
        if (parent.getPartitionBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        if (parent.getOrderingScheme().isPresent()) {
            if (parent.getOrderingScheme().get().getOrderBy().stream().anyMatch(child.getCreatedSymbols()::contains)) return true;
        }
        if (!parent.getWindowFunctions().values().stream().map(WindowNode.Function::getFunctionCall).map(SymbolsExtractor::extractUnique).flatMap(Collection::stream).anyMatch(child.getCreatedSymbols()::contains)) return false;
        return true;
    }
}

