/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.sql.planner.SortExpressionContext;
import io.prestosql.sql.planner.SortExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Join;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class JoinNode
extends PlanNode {
    private final Type type;
    private final PlanNode left;
    private final PlanNode right;
    private final List<EquiJoinClause> criteria;
    private final List<Symbol> outputSymbols;
    private final Optional<Expression> filter;
    private final Optional<Symbol> leftHashSymbol;
    private final Optional<Symbol> rightHashSymbol;
    private final Optional<DistributionType> distributionType;
    private final Optional<Boolean> spillable;

    @JsonCreator
    public JoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="type") Type type, @JsonProperty(value="left") PlanNode left, @JsonProperty(value="right") PlanNode right, @JsonProperty(value="criteria") List<EquiJoinClause> criteria, @JsonProperty(value="outputSymbols") List<Symbol> outputSymbols, @JsonProperty(value="filter") Optional<Expression> filter, @JsonProperty(value="leftHashSymbol") Optional<Symbol> leftHashSymbol, @JsonProperty(value="rightHashSymbol") Optional<Symbol> rightHashSymbol, @JsonProperty(value="distributionType") Optional<DistributionType> distributionType, @JsonProperty(value="spillable") Optional<Boolean> spillable) {
        super(id);
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        Objects.requireNonNull(criteria, "criteria is null");
        Objects.requireNonNull(outputSymbols, "outputSymbols is null");
        Objects.requireNonNull(filter, "filter is null");
        Objects.requireNonNull(leftHashSymbol, "leftHashSymbol is null");
        Objects.requireNonNull(rightHashSymbol, "rightHashSymbol is null");
        Objects.requireNonNull(distributionType, "distributionType is null");
        Objects.requireNonNull(spillable, "spillable is null");
        this.type = type;
        this.left = left;
        this.right = right;
        this.criteria = ImmutableList.copyOf(criteria);
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.filter = filter;
        this.leftHashSymbol = leftHashSymbol;
        this.rightHashSymbol = rightHashSymbol;
        this.distributionType = distributionType;
        this.spillable = spillable;
        ImmutableSet inputSymbols = ImmutableSet.builder().addAll(left.getOutputSymbols()).addAll(right.getOutputSymbols()).build();
        Preconditions.checkArgument((boolean)new HashSet(inputSymbols).containsAll(outputSymbols), (Object)"Left and right join inputs do not contain all output symbols");
        Preconditions.checkArgument((!this.isCrossJoin() || inputSymbols.size() == outputSymbols.size() ? 1 : 0) != 0, (Object)"Cross join does not support output symbols pruning or reordering");
        Preconditions.checkArgument((!criteria.isEmpty() || !leftHashSymbol.isPresent() ? 1 : 0) != 0, (Object)"Left hash symbol is only valid in an equijoin");
        Preconditions.checkArgument((!criteria.isEmpty() || !rightHashSymbol.isPresent() ? 1 : 0) != 0, (Object)"Right hash symbol is only valid in an equijoin");
        if (distributionType.isPresent()) {
            Preconditions.checkArgument((distributionType.get() != DistributionType.REPLICATED || type != Type.RIGHT && type != Type.FULL ? 1 : 0) != 0, (String)"%s join do not work with %s distribution type", (Object)((Object)type), (Object)((Object)distributionType.get()));
            Preconditions.checkArgument((distributionType.get() != DistributionType.PARTITIONED || !criteria.isEmpty() || type == Type.RIGHT || type == Type.FULL ? 1 : 0) != 0, (String)"Equi criteria are empty, so %s join should not have %s distribution type", (Object)((Object)type), (Object)((Object)distributionType.get()));
        }
    }

    public JoinNode flipChildren() {
        return new JoinNode(this.getId(), JoinNode.flipType(this.type), this.right, this.left, JoinNode.flipJoinCriteria(this.criteria), JoinNode.flipOutputSymbols(this.getOutputSymbols(), this.left, this.right), this.filter, this.rightHashSymbol, this.leftHashSymbol, this.distributionType, this.spillable);
    }

    private static Type flipType(Type type) {
        switch (type) {
            case INNER: {
                return Type.INNER;
            }
            case FULL: {
                return Type.FULL;
            }
            case LEFT: {
                return Type.RIGHT;
            }
            case RIGHT: {
                return Type.LEFT;
            }
        }
        throw new IllegalStateException("No inverse defined for join type: " + (Object)((Object)type));
    }

    private static List<EquiJoinClause> flipJoinCriteria(List<EquiJoinClause> joinCriteria) {
        return (List)joinCriteria.stream().map(EquiJoinClause::flip).collect(ImmutableList.toImmutableList());
    }

    private static List<Symbol> flipOutputSymbols(List<Symbol> outputSymbols, PlanNode left, PlanNode right) {
        List leftSymbols = outputSymbols.stream().filter(symbol -> left.getOutputSymbols().contains(symbol)).collect(Collectors.toList());
        List rightSymbols = outputSymbols.stream().filter(symbol -> right.getOutputSymbols().contains(symbol)).collect(Collectors.toList());
        return ImmutableList.builder().addAll(rightSymbols).addAll(leftSymbols).build();
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="left")
    public PlanNode getLeft() {
        return this.left;
    }

    @JsonProperty(value="right")
    public PlanNode getRight() {
        return this.right;
    }

    @JsonProperty(value="criteria")
    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    @JsonProperty(value="filter")
    public Optional<Expression> getFilter() {
        return this.filter;
    }

    public Optional<SortExpressionContext> getSortExpressionContext() {
        return this.filter.flatMap(filter -> SortExpressionExtractor.extractSortExpression((Set<Symbol>)ImmutableSet.copyOf(this.right.getOutputSymbols()), filter));
    }

    @JsonProperty(value="leftHashSymbol")
    public Optional<Symbol> getLeftHashSymbol() {
        return this.leftHashSymbol;
    }

    @JsonProperty(value="rightHashSymbol")
    public Optional<Symbol> getRightHashSymbol() {
        return this.rightHashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="distributionType")
    public Optional<DistributionType> getDistributionType() {
        return this.distributionType;
    }

    @JsonProperty(value="spillable")
    public Optional<Boolean> isSpillable() {
        return this.spillable;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new JoinNode(this.getId(), this.type, newChildren.get(0), newChildren.get(1), this.criteria, this.outputSymbols, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, this.spillable);
    }

    public JoinNode withDistributionType(DistributionType distributionType) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.outputSymbols, this.filter, this.leftHashSymbol, this.rightHashSymbol, Optional.of(distributionType), this.spillable);
    }

    public JoinNode withSpillable(boolean spillable) {
        return new JoinNode(this.getId(), this.type, this.left, this.right, this.criteria, this.outputSymbols, this.filter, this.leftHashSymbol, this.rightHashSymbol, this.distributionType, Optional.of(spillable));
    }

    public boolean isCrossJoin() {
        return this.criteria.isEmpty() && !this.filter.isPresent() && this.type == Type.INNER;
    }

    public static class EquiJoinClause {
        private final Symbol left;
        private final Symbol right;

        @JsonCreator
        public EquiJoinClause(@JsonProperty(value="left") Symbol left, @JsonProperty(value="right") Symbol right) {
            this.left = Objects.requireNonNull(left, "left is null");
            this.right = Objects.requireNonNull(right, "right is null");
        }

        @JsonProperty(value="left")
        public Symbol getLeft() {
            return this.left;
        }

        @JsonProperty(value="right")
        public Symbol getRight() {
            return this.right;
        }

        public ComparisonExpression toExpression() {
            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)this.left.toSymbolReference(), (Expression)this.right.toSymbolReference());
        }

        public EquiJoinClause flip() {
            return new EquiJoinClause(this.right, this.left);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            EquiJoinClause other = (EquiJoinClause)obj;
            return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public String toString() {
            return String.format("%s = %s", this.left, this.right);
        }
    }

    public static enum Type {
        INNER("InnerJoin"),
        LEFT("LeftJoin"),
        RIGHT("RightJoin"),
        FULL("FullJoin");

        private final String joinLabel;

        private Type(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public static Type typeConvert(Join.Type joinType) {
            switch (joinType) {
                case CROSS: 
                case IMPLICIT: 
                case INNER: {
                    return INNER;
                }
                case LEFT: {
                    return LEFT;
                }
                case RIGHT: {
                    return RIGHT;
                }
                case FULL: {
                    return FULL;
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + joinType);
        }
    }

    public static enum DistributionType {
        PARTITIONED,
        REPLICATED;

    }
}

