/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.Assignments;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Assignments assignments;

    @JsonCreator
    public ProjectNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Assignments assignments) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(assignments, "assignments is null");
        this.source = source;
        this.assignments = assignments;
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.assignments.getOutputs();
    }

    @JsonProperty
    public Assignments getAssignments() {
        return this.assignments;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    public boolean isIdentity() {
        for (Map.Entry<Symbol, Expression> entry : this.assignments.entrySet()) {
            Expression expression = entry.getValue();
            Symbol symbol = entry.getKey();
            if (expression instanceof SymbolReference && ((SymbolReference)expression).getName().equals(symbol.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new ProjectNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.assignments);
    }
}

