/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.prestosql.metadata.InsertTableHandle;
import io.prestosql.metadata.NewTableLayout;
import io.prestosql.metadata.OutputTableHandle;
import io.prestosql.metadata.TableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.plan.StatisticAggregations;
import io.prestosql.sql.planner.plan.StatisticAggregationsDescriptor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableWriterNode
extends PlanNode {
    private final PlanNode source;
    private final WriterTarget target;
    private final Symbol rowCountSymbol;
    private final Symbol fragmentSymbol;
    private final List<Symbol> columns;
    private final List<String> columnNames;
    private final Optional<PartitioningScheme> partitioningScheme;
    private final Optional<StatisticAggregations> statisticsAggregation;
    private final Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor;
    private final List<Symbol> outputs;

    @JsonCreator
    public TableWriterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="target") WriterTarget target, @JsonProperty(value="rowCountSymbol") Symbol rowCountSymbol, @JsonProperty(value="fragmentSymbol") Symbol fragmentSymbol, @JsonProperty(value="columns") List<Symbol> columns, @JsonProperty(value="columnNames") List<String> columnNames, @JsonProperty(value="partitioningScheme") Optional<PartitioningScheme> partitioningScheme, @JsonProperty(value="statisticsAggregation") Optional<StatisticAggregations> statisticsAggregation, @JsonProperty(value="statisticsAggregationDescriptor") Optional<StatisticAggregationsDescriptor<Symbol>> statisticsAggregationDescriptor) {
        super(id);
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(columnNames, "columnNames is null");
        Preconditions.checkArgument((columns.size() == columnNames.size() ? 1 : 0) != 0, (Object)"columns and columnNames sizes don't match");
        this.source = Objects.requireNonNull(source, "source is null");
        this.target = Objects.requireNonNull(target, "target is null");
        this.rowCountSymbol = Objects.requireNonNull(rowCountSymbol, "rowCountSymbol is null");
        this.fragmentSymbol = Objects.requireNonNull(fragmentSymbol, "fragmentSymbol is null");
        this.columns = ImmutableList.copyOf(columns);
        this.columnNames = ImmutableList.copyOf(columnNames);
        this.partitioningScheme = Objects.requireNonNull(partitioningScheme, "partitioningScheme is null");
        this.statisticsAggregation = Objects.requireNonNull(statisticsAggregation, "statisticsAggregation is null");
        this.statisticsAggregationDescriptor = Objects.requireNonNull(statisticsAggregationDescriptor, "statisticsAggregationDescriptor is null");
        Preconditions.checkArgument((statisticsAggregation.isPresent() == statisticsAggregationDescriptor.isPresent() ? 1 : 0) != 0, (Object)"statisticsAggregation and statisticsAggregationDescriptor must be either present or absent");
        ImmutableList.Builder outputs = ImmutableList.builder().add((Object)rowCountSymbol).add((Object)fragmentSymbol);
        statisticsAggregation.ifPresent(aggregation -> {
            outputs.addAll(aggregation.getGroupingSymbols());
            outputs.addAll(aggregation.getAggregations().keySet());
        });
        this.outputs = outputs.build();
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WriterTarget getTarget() {
        return this.target;
    }

    @JsonProperty
    public Symbol getRowCountSymbol() {
        return this.rowCountSymbol;
    }

    @JsonProperty
    public Symbol getFragmentSymbol() {
        return this.fragmentSymbol;
    }

    @JsonProperty
    public List<Symbol> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @JsonProperty
    public Optional<PartitioningScheme> getPartitioningScheme() {
        return this.partitioningScheme;
    }

    @JsonProperty
    public Optional<StatisticAggregations> getStatisticsAggregation() {
        return this.statisticsAggregation;
    }

    @JsonProperty
    public Optional<StatisticAggregationsDescriptor<Symbol>> getStatisticsAggregationDescriptor() {
        return this.statisticsAggregationDescriptor;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.outputs;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableWriter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TableWriterNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.target, this.rowCountSymbol, this.fragmentSymbol, this.columns, this.columnNames, this.partitioningScheme, this.statisticsAggregation, this.statisticsAggregationDescriptor);
    }

    public static class DeleteHandle
    extends WriterTarget {
        private final TableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public DeleteHandle(@JsonProperty(value="handle") TableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public TableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertHandle
    extends WriterTarget {
        private final InsertTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public InsertHandle(@JsonProperty(value="handle") InsertTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public InsertTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class InsertReference
    extends WriterTarget {
        private final TableHandle handle;

        public InsertReference(TableHandle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        public TableHandle getHandle() {
            return this.handle;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateHandle
    extends WriterTarget {
        private final OutputTableHandle handle;
        private final SchemaTableName schemaTableName;

        @JsonCreator
        public CreateHandle(@JsonProperty(value="handle") OutputTableHandle handle, @JsonProperty(value="schemaTableName") SchemaTableName schemaTableName) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
            this.schemaTableName = Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        }

        @JsonProperty
        public OutputTableHandle getHandle() {
            return this.handle;
        }

        @JsonProperty
        public SchemaTableName getSchemaTableName() {
            return this.schemaTableName;
        }

        @Override
        public String toString() {
            return this.handle.toString();
        }
    }

    public static class CreateName
    extends WriterTarget {
        private final String catalog;
        private final ConnectorTableMetadata tableMetadata;
        private final Optional<NewTableLayout> layout;

        public CreateName(String catalog, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
            this.catalog = Objects.requireNonNull(catalog, "catalog is null");
            this.tableMetadata = Objects.requireNonNull(tableMetadata, "tableMetadata is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
        }

        public String getCatalog() {
            return this.catalog;
        }

        public ConnectorTableMetadata getTableMetadata() {
            return this.tableMetadata;
        }

        public Optional<NewTableLayout> getLayout() {
            return this.layout;
        }

        @Override
        public String toString() {
            return this.catalog + "." + this.tableMetadata.getTable();
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="@type")
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CreateHandle.class, name="CreateHandle"), @JsonSubTypes.Type(value=InsertHandle.class, name="InsertHandle"), @JsonSubTypes.Type(value=DeleteHandle.class, name="DeleteHandle")})
    public static abstract class WriterTarget {
        public abstract String toString();
    }
}

