/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.planprinter;

import io.airlift.slice.Slice;
import io.prestosql.Session;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.InterpretedFunctionInvoker;

public final class PlanPrinterUtil {
    private PlanPrinterUtil() {
    }

    static String castToVarchar(Type type, Object value, FunctionRegistry functionRegistry, Session session) {
        try {
            return PlanPrinterUtil.castToVarcharOrFail(type, value, functionRegistry, session);
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
    }

    static String castToVarcharOrFail(Type type, Object value, FunctionRegistry functionRegistry, Session session) throws OperatorNotFoundException {
        if (value == null) {
            return "NULL";
        }
        Signature coercion = functionRegistry.getCoercion(type, (Type)VarcharType.VARCHAR);
        Slice coerced = (Slice)new InterpretedFunctionInvoker(functionRegistry).invoke(coercion, session.toConnectorSession(), value);
        return coerced.toStringUtf8();
    }
}

