/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.VariableReferenceExpression;
import java.util.Objects;

public class DeterminismEvaluator {
    final FunctionRegistry registry;

    public DeterminismEvaluator(FunctionRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public boolean isDeterministic(RowExpression expression) {
        return expression.accept(new Visitor(this.registry), null);
    }

    private static class Visitor
    implements RowExpressionVisitor<Boolean, Void> {
        private final FunctionRegistry registry;

        public Visitor(FunctionRegistry registry) {
            this.registry = registry;
        }

        @Override
        public Boolean visitInputReference(InputReferenceExpression reference, Void context) {
            return true;
        }

        @Override
        public Boolean visitConstant(ConstantExpression literal, Void context) {
            return true;
        }

        @Override
        public Boolean visitCall(CallExpression call, Void context) {
            Signature signature = call.getSignature();
            if (this.registry.isRegistered(signature) && !this.registry.getScalarFunctionImplementation(signature).isDeterministic()) {
                return false;
            }
            return call.getArguments().stream().allMatch(expression -> expression.accept(this, context));
        }

        @Override
        public Boolean visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda.getBody().accept(this, context);
        }

        @Override
        public Boolean visitVariableReference(VariableReferenceExpression reference, Void context) {
            return true;
        }
    }
}

