/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.relational;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.airlift.slice.Slices;
import io.prestosql.Session;
import io.prestosql.SystemSessionProperties;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.Signature;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.CharType;
import io.prestosql.spi.type.DecimalParseResult;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.ConstantExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.InputReferenceExpression;
import io.prestosql.sql.relational.LambdaDefinitionExpression;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.sql.relational.RowExpressionVisitor;
import io.prestosql.sql.relational.Signatures;
import io.prestosql.sql.relational.VariableReferenceExpression;
import io.prestosql.sql.relational.optimizer.ExpressionOptimizer;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BinaryLiteral;
import io.prestosql.sql.tree.BindExpression;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CharLiteral;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FieldReference;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.Identifier;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IntervalLiteral;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaArgumentDeclaration;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeRef;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullIfExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TimeLiteral;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.WhenClause;
import io.prestosql.type.JsonType;
import io.prestosql.type.LikePatternType;
import io.prestosql.type.UnknownType;
import io.prestosql.util.DateTimeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SqlToRowExpressionTranslator {
    private SqlToRowExpressionTranslator() {
    }

    public static RowExpression translate(Expression expression, FunctionKind functionKind, Map<NodeRef<Expression>, Type> types, Map<Symbol, Integer> layout, FunctionRegistry functionRegistry, TypeManager typeManager, Session session, boolean optimize) {
        Visitor visitor = new Visitor(functionKind, types, typeManager, layout, session.getTimeZoneKey(), SystemSessionProperties.isLegacyTimestamp(session));
        RowExpression result = (RowExpression)visitor.process((Node)expression, null);
        Objects.requireNonNull(result, "translated expression is null");
        if (optimize) {
            ExpressionOptimizer optimizer = new ExpressionOptimizer(functionRegistry, typeManager, session);
            return optimizer.optimize(result);
        }
        return result;
    }

    private static class Visitor
    extends AstVisitor<RowExpression, Void> {
        private final FunctionKind functionKind;
        private final Map<NodeRef<Expression>, Type> types;
        private final TypeManager typeManager;
        private final Map<Symbol, Integer> layout;
        private final TimeZoneKey timeZoneKey;
        private final boolean isLegacyTimestamp;

        private Visitor(FunctionKind functionKind, Map<NodeRef<Expression>, Type> types, TypeManager typeManager, Map<Symbol, Integer> layout, TimeZoneKey timeZoneKey, boolean isLegacyTimestamp) {
            this.functionKind = functionKind;
            this.types = ImmutableMap.copyOf(Objects.requireNonNull(types, "types is null"));
            this.typeManager = typeManager;
            this.layout = layout;
            this.timeZoneKey = timeZoneKey;
            this.isLegacyTimestamp = isLegacyTimestamp;
        }

        private Type getType(Expression node) {
            return this.types.get(NodeRef.of((Node)node));
        }

        protected RowExpression visitExpression(Expression node, Void context) {
            throw new UnsupportedOperationException("not yet implemented: expression translator for " + node.getClass().getName());
        }

        protected RowExpression visitFieldReference(FieldReference node, Void context) {
            return Expressions.field(node.getFieldIndex(), this.getType((Expression)node));
        }

        protected RowExpression visitNullLiteral(NullLiteral node, Void context) {
            return Expressions.constantNull((Type)UnknownType.UNKNOWN);
        }

        protected RowExpression visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)BooleanType.BOOLEAN);
        }

        protected RowExpression visitLongLiteral(LongLiteral node, Void context) {
            if (node.getValue() >= Integer.MIN_VALUE && node.getValue() <= Integer.MAX_VALUE) {
                return Expressions.constant(node.getValue(), (Type)IntegerType.INTEGER);
            }
            return Expressions.constant(node.getValue(), (Type)BigintType.BIGINT);
        }

        protected RowExpression visitDoubleLiteral(DoubleLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)DoubleType.DOUBLE);
        }

        protected RowExpression visitDecimalLiteral(DecimalLiteral node, Void context) {
            DecimalParseResult parseResult = Decimals.parse((String)node.getValue());
            return Expressions.constant(parseResult.getObject(), (Type)parseResult.getType());
        }

        protected RowExpression visitStringLiteral(StringLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)VarcharType.createVarcharType((int)SliceUtf8.countCodePoints((Slice)node.getSlice())));
        }

        protected RowExpression visitCharLiteral(CharLiteral node, Void context) {
            return Expressions.constant(node.getSlice(), (Type)CharType.createCharType((long)node.getValue().length()));
        }

        protected RowExpression visitBinaryLiteral(BinaryLiteral node, Void context) {
            return Expressions.constant(node.getValue(), (Type)VarbinaryType.VARBINARY);
        }

        protected RowExpression visitGenericLiteral(GenericLiteral node, Void context) {
            Type type;
            try {
                type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported type: " + node.getType());
            }
            if (JsonType.JSON.equals(type)) {
                return Expressions.call(new Signature("json_parse", FunctionKind.SCALAR, this.getType((Expression)node).getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()), this.getType((Expression)node), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
            }
            return Expressions.call(Signatures.castSignature(this.getType((Expression)node), (Type)VarcharType.VARCHAR), this.getType((Expression)node), Expressions.constant(Slices.utf8Slice((String)node.getValue()), (Type)VarcharType.VARCHAR));
        }

        protected RowExpression visitTimeLiteral(TimeLiteral node, Void context) {
            long value = this.getType((Expression)node).equals(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE) ? DateTimeUtils.parseTimeWithTimeZone(node.getValue()) : (this.isLegacyTimestamp ? DateTimeUtils.parseTimeWithoutTimeZone(this.timeZoneKey, node.getValue()) : DateTimeUtils.parseTimeWithoutTimeZone(node.getValue()));
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitTimestampLiteral(TimestampLiteral node, Void context) {
            long value = this.isLegacyTimestamp ? DateTimeUtils.parseTimestampLiteral(this.timeZoneKey, node.getValue()) : DateTimeUtils.parseTimestampLiteral(node.getValue());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitIntervalLiteral(IntervalLiteral node, Void context) {
            long value = node.isYearToMonth() ? (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField()) : (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
            return Expressions.constant(value, this.getType((Expression)node));
        }

        protected RowExpression visitComparisonExpression(ComparisonExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.comparisonExpressionSignature(node.getOperator(), left.getType(), right.getType()), (Type)BooleanType.BOOLEAN, left, right);
        }

        protected RowExpression visitFunctionCall(FunctionCall node, Void context) {
            List arguments = (List)node.getArguments().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).map(Type::getTypeSignature).collect(ImmutableList.toImmutableList());
            Signature signature = new Signature(node.getName().getSuffix(), this.functionKind, this.getType((Expression)node).getTypeSignature(), argumentTypes);
            return Expressions.call(signature, this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSymbolReference(SymbolReference node, Void context) {
            Integer field = this.layout.get(Symbol.from((Expression)node));
            if (field != null) {
                return Expressions.field(field, this.getType((Expression)node));
            }
            return new VariableReferenceExpression(node.getName(), this.getType((Expression)node));
        }

        protected RowExpression visitLambdaExpression(LambdaExpression node, Void context) {
            RowExpression body = (RowExpression)this.process((Node)node.getBody(), context);
            Type type = this.getType((Expression)node);
            List typeParameters = type.getTypeParameters();
            List<Type> argumentTypes = typeParameters.subList(0, typeParameters.size() - 1);
            List argumentNames = (List)node.getArguments().stream().map(LambdaArgumentDeclaration::getName).map(Identifier::getValue).collect(ImmutableList.toImmutableList());
            return new LambdaDefinitionExpression(argumentTypes, argumentNames, body);
        }

        protected RowExpression visitBindExpression(BindExpression node, Void context) {
            ImmutableList.Builder valueTypesBuilder = ImmutableList.builder();
            ImmutableList.Builder argumentsBuilder = ImmutableList.builder();
            for (Expression value : node.getValues()) {
                RowExpression valueRowExpression = (RowExpression)this.process((Node)value, context);
                valueTypesBuilder.add((Object)valueRowExpression.getType());
                argumentsBuilder.add((Object)valueRowExpression);
            }
            RowExpression function = (RowExpression)this.process((Node)node.getFunction(), context);
            argumentsBuilder.add((Object)function);
            return Expressions.call(Signatures.bindSignature(this.getType((Expression)node), (List<Type>)valueTypesBuilder.build(), function.getType()), this.getType((Expression)node), (List<RowExpression>)argumentsBuilder.build());
        }

        protected RowExpression visitArithmeticBinary(ArithmeticBinaryExpression node, Void context) {
            RowExpression left = (RowExpression)this.process((Node)node.getLeft(), context);
            RowExpression right = (RowExpression)this.process((Node)node.getRight(), context);
            return Expressions.call(Signatures.arithmeticExpressionSignature(node.getOperator(), this.getType((Expression)node), left.getType(), right.getType()), this.getType((Expression)node), left, right);
        }

        protected RowExpression visitArithmeticUnary(ArithmeticUnaryExpression node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            switch (node.getSign()) {
                case PLUS: {
                    return expression;
                }
                case MINUS: {
                    return Expressions.call(Signatures.arithmeticNegationSignature(this.getType((Expression)node), expression.getType()), this.getType((Expression)node), expression);
                }
            }
            throw new UnsupportedOperationException("Unsupported unary operator: " + node.getSign());
        }

        protected RowExpression visitLogicalBinaryExpression(LogicalBinaryExpression node, Void context) {
            return Expressions.call(Signatures.logicalExpressionSignature(node.getOperator()), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getLeft(), context), (RowExpression)this.process((Node)node.getRight(), context));
        }

        protected RowExpression visitCast(Cast node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getExpression(), context);
            if (node.isTypeOnly()) {
                return Visitor.changeType(value, this.getType((Expression)node));
            }
            if (node.isSafe()) {
                return Expressions.call(Signatures.tryCastSignature(this.getType((Expression)node), value.getType()), this.getType((Expression)node), value);
            }
            return Expressions.call(Signatures.castSignature(this.getType((Expression)node), value.getType()), this.getType((Expression)node), value);
        }

        private static RowExpression changeType(RowExpression value, Type targetType) {
            ChangeTypeVisitor visitor = new ChangeTypeVisitor(targetType);
            return value.accept(visitor, null);
        }

        protected RowExpression visitCoalesceExpression(CoalesceExpression node, Void context) {
            List arguments = (List)node.getOperands().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.coalesceSignature(this.getType((Expression)node), argumentTypes), this.getType((Expression)node), arguments);
        }

        protected RowExpression visitSimpleCaseExpression(SimpleCaseExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getOperand(), context));
            for (WhenClause clause : node.getWhenClauses()) {
                arguments.add((Object)Expressions.call(Signatures.whenSignature(this.getType((Expression)clause)), this.getType((Expression)clause), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context)));
            }
            Type returnType = this.getType((Expression)node);
            arguments.add((Object)node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(returnType)));
            return Expressions.call(Signatures.switchSignature(returnType), returnType, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitSearchedCaseExpression(SearchedCaseExpression node, Void context) {
            RowExpression expression = node.getDefaultValue().map(value -> (RowExpression)this.process((Node)value, context)).orElse(Expressions.constantNull(this.getType((Expression)node)));
            for (WhenClause clause : Lists.reverse((List)node.getWhenClauses())) {
                expression = Expressions.call(Signatures.ifSignature(this.getType((Expression)node)), this.getType((Expression)node), (RowExpression)this.process((Node)clause.getOperand(), context), (RowExpression)this.process((Node)clause.getResult(), context), expression);
            }
            return expression;
        }

        protected RowExpression visitDereferenceExpression(DereferenceExpression node, Void context) {
            RowType rowType = (RowType)this.getType(node.getBase());
            String fieldName = node.getField().getValue();
            List fields = rowType.getFields();
            int index = -1;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field field = (RowType.Field)fields.get(i);
                if (!field.getName().isPresent() || !((String)field.getName().get()).equalsIgnoreCase(fieldName)) continue;
                Preconditions.checkArgument((index < 0 ? 1 : 0) != 0, (String)"Ambiguous field %s in type %s", (Object)field, (Object)rowType.getDisplayName());
                index = i;
            }
            Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (String)"could not find field name: %s", (Object)node.getField());
            Type returnType = this.getType((Expression)node);
            return Expressions.call(Signatures.dereferenceSignature(returnType, rowType), returnType, (RowExpression)this.process((Node)node.getBase(), context), Expressions.constant(index, (Type)IntegerType.INTEGER));
        }

        protected RowExpression visitIfExpression(IfExpression node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getCondition(), context)).add(this.process((Node)node.getTrueValue(), context));
            if (node.getFalseValue().isPresent()) {
                arguments.add(this.process((Node)node.getFalseValue().get(), context));
            } else {
                arguments.add((Object)Expressions.constantNull(this.getType((Expression)node)));
            }
            return Expressions.call(Signatures.ifSignature(this.getType((Expression)node)), this.getType((Expression)node), (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitTryExpression(TryExpression node, Void context) {
            return Expressions.call(Signatures.trySignature(this.getType((Expression)node)), this.getType((Expression)node), (RowExpression)this.process((Node)node.getInnerExpression(), context));
        }

        protected RowExpression visitInPredicate(InPredicate node, Void context) {
            ImmutableList.Builder arguments = ImmutableList.builder();
            arguments.add(this.process((Node)node.getValue(), context));
            InListExpression values = (InListExpression)node.getValueList();
            for (Expression value : values.getValues()) {
                arguments.add(this.process((Node)value, context));
            }
            return Expressions.call(Signatures.inSignature(), (Type)BooleanType.BOOLEAN, (List<RowExpression>)arguments.build());
        }

        protected RowExpression visitIsNotNullPredicate(IsNotNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, (List<RowExpression>)ImmutableList.of((Object)expression)));
        }

        protected RowExpression visitIsNullPredicate(IsNullPredicate node, Void context) {
            RowExpression expression = (RowExpression)this.process((Node)node.getValue(), context);
            return Expressions.call(Signatures.isNullSignature(expression.getType()), (Type)BooleanType.BOOLEAN, expression);
        }

        protected RowExpression visitNotExpression(NotExpression node, Void context) {
            return Expressions.call(Signatures.notSignature(), (Type)BooleanType.BOOLEAN, (RowExpression)this.process((Node)node.getValue(), context));
        }

        protected RowExpression visitNullIfExpression(NullIfExpression node, Void context) {
            RowExpression first = (RowExpression)this.process((Node)node.getFirst(), context);
            RowExpression second = (RowExpression)this.process((Node)node.getSecond(), context);
            return Expressions.call(Signatures.nullIfSignature(this.getType((Expression)node), first.getType(), second.getType()), this.getType((Expression)node), first, second);
        }

        protected RowExpression visitBetweenPredicate(BetweenPredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression min = (RowExpression)this.process((Node)node.getMin(), context);
            RowExpression max = (RowExpression)this.process((Node)node.getMax(), context);
            return Expressions.call(Signatures.betweenSignature(value.getType(), min.getType(), max.getType()), (Type)BooleanType.BOOLEAN, value, min, max);
        }

        protected RowExpression visitLikePredicate(LikePredicate node, Void context) {
            RowExpression value = (RowExpression)this.process((Node)node.getValue(), context);
            RowExpression pattern = (RowExpression)this.process((Node)node.getPattern(), context);
            if (node.getEscape().isPresent()) {
                RowExpression escape = (RowExpression)this.process((Node)node.getEscape().get(), context);
                return this.likeFunctionCall(value, Expressions.call(Signatures.likePatternSignature(), (Type)LikePatternType.LIKE_PATTERN, pattern, escape));
            }
            return this.likeFunctionCall(value, Expressions.call(Signatures.castSignature((Type)LikePatternType.LIKE_PATTERN, (Type)VarcharType.VARCHAR), (Type)LikePatternType.LIKE_PATTERN, pattern));
        }

        private RowExpression likeFunctionCall(RowExpression value, RowExpression pattern) {
            if (value.getType() instanceof VarcharType) {
                return Expressions.call(Signatures.likeVarcharSignature(), (Type)BooleanType.BOOLEAN, value, pattern);
            }
            Preconditions.checkState((boolean)(value.getType() instanceof CharType), (Object)"LIKE value type is neither VARCHAR or CHAR");
            return Expressions.call(Signatures.likeCharSignature(value.getType()), (Type)BooleanType.BOOLEAN, value, pattern);
        }

        protected RowExpression visitSubscriptExpression(SubscriptExpression node, Void context) {
            RowExpression base = (RowExpression)this.process((Node)node.getBase(), context);
            RowExpression index = (RowExpression)this.process((Node)node.getIndex(), context);
            return Expressions.call(Signatures.subscriptSignature(this.getType((Expression)node), base.getType(), index.getType()), this.getType((Expression)node), base, index);
        }

        protected RowExpression visitArrayConstructor(ArrayConstructor node, Void context) {
            List arguments = (List)node.getValues().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            List argumentTypes = (List)arguments.stream().map(RowExpression::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.arrayConstructorSignature(this.getType((Expression)node), argumentTypes), this.getType((Expression)node), arguments);
        }

        protected RowExpression visitRow(Row node, Void context) {
            List arguments = (List)node.getItems().stream().map(value -> (RowExpression)this.process((Node)value, context)).collect(ImmutableList.toImmutableList());
            Type returnType = this.getType((Expression)node);
            List argumentTypes = (List)node.getItems().stream().map(this::getType).collect(ImmutableList.toImmutableList());
            return Expressions.call(Signatures.rowConstructorSignature(returnType, argumentTypes), returnType, arguments);
        }

        private static class ChangeTypeVisitor
        implements RowExpressionVisitor<RowExpression, Void> {
            private final Type targetType;

            private ChangeTypeVisitor(Type targetType) {
                this.targetType = targetType;
            }

            @Override
            public RowExpression visitCall(CallExpression call, Void context) {
                return new CallExpression(call.getSignature(), this.targetType, call.getArguments());
            }

            @Override
            public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
                return Expressions.field(reference.getField(), this.targetType);
            }

            @Override
            public RowExpression visitConstant(ConstantExpression literal, Void context) {
                return Expressions.constant(literal.getValue(), this.targetType);
            }

            @Override
            public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
                return new VariableReferenceExpression(reference.getName(), this.targetType);
            }
        }
    }
}

