/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.annotations.VisibleForTesting;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.operator.aggregation.AggregationFromAnnotationsParser;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.type.TypeRegistry;
import java.util.List;

public class AggregationTestUtils {
    private AggregationTestUtils() {
    }

    @VisibleForTesting
    public static InternalAggregationFunction generateInternalAggregationFunction(Class<?> clazz, TypeSignature outputType, List<TypeSignature> inputTypes) {
        return AggregationTestUtils.generateInternalAggregationFunction(clazz, outputType, inputTypes, new TypeRegistry());
    }

    @VisibleForTesting
    public static InternalAggregationFunction generateInternalAggregationFunction(Class<?> clazz, TypeSignature outputType, List<TypeSignature> inputTypes, TypeManager typeManager) {
        return AggregationTestUtils.generateInternalAggregationFunction(clazz, outputType, inputTypes, typeManager, BoundVariables.builder().build(), inputTypes.size());
    }

    @VisibleForTesting
    public static InternalAggregationFunction generateInternalAggregationFunction(Class<?> clazz, TypeSignature outputType, List<TypeSignature> inputTypes, TypeManager typeManager, BoundVariables boundVariables, int arity) {
        return AggregationFromAnnotationsParser.parseFunctionDefinitionWithTypesConstraint(clazz, outputType, inputTypes).specialize(boundVariables, arity, typeManager);
    }
}

