/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControlManager;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.transaction.TransactionId;
import io.prestosql.transaction.TransactionManager;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class TestingAccessControlManager
extends AccessControlManager {
    private final Set<TestingPrivilege> denyPrivileges = new HashSet<TestingPrivilege>();

    @Inject
    public TestingAccessControlManager(TransactionManager transactionManager) {
        super(transactionManager);
        this.setSystemAccessControl("allow-all", (Map<String, String>)ImmutableMap.of());
    }

    public static TestingPrivilege privilege(String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.empty(), entityName, type);
    }

    public static TestingPrivilege privilege(String userName, String entityName, TestingPrivilegeType type) {
        return new TestingPrivilege(Optional.of(userName), entityName, type);
    }

    public void deny(TestingPrivilege ... deniedPrivileges) {
        Collections.addAll(this.denyPrivileges, deniedPrivileges);
    }

    public void reset() {
        this.denyPrivileges.clear();
    }

    @Override
    public void checkCanSetUser(Optional<Principal> principal, String userName) {
        if (this.shouldDenyPrivilege(userName, userName, TestingPrivilegeType.SET_USER)) {
            AccessDeniedException.denySetUser(principal, (String)userName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetUser(principal, userName);
        }
    }

    @Override
    public void checkCanCreateSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.CREATE_SCHEMA)) {
            AccessDeniedException.denyCreateSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateSchema(transactionId, identity, schemaName);
        }
    }

    @Override
    public void checkCanDropSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.DROP_SCHEMA)) {
            AccessDeniedException.denyDropSchema((String)schemaName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropSchema(transactionId, identity, schemaName);
        }
    }

    @Override
    public void checkCanRenameSchema(TransactionId transactionId, Identity identity, CatalogSchemaName schemaName, String newSchemaName) {
        if (this.shouldDenyPrivilege(identity.getUser(), schemaName.getSchemaName(), TestingPrivilegeType.RENAME_SCHEMA)) {
            AccessDeniedException.denyRenameSchema((String)schemaName.toString(), (String)newSchemaName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameSchema(transactionId, identity, schemaName, newSchemaName);
        }
    }

    @Override
    public void checkCanCreateTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_TABLE)) {
            AccessDeniedException.denyCreateTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateTable(transactionId, identity, tableName);
        }
    }

    @Override
    public void checkCanDropTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_TABLE)) {
            AccessDeniedException.denyDropTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropTable(transactionId, identity, tableName);
        }
    }

    @Override
    public void checkCanRenameTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, QualifiedObjectName newTableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_TABLE)) {
            AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanRenameTable(transactionId, identity, tableName, newTableName);
        }
    }

    @Override
    public void checkCanSetTableComment(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.COMMENT_TABLE)) {
            AccessDeniedException.denyCommentTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetTableComment(transactionId, identity, tableName);
        }
    }

    @Override
    public void checkCanAddColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.ADD_COLUMN)) {
            AccessDeniedException.denyAddColumn((String)tableName.toString());
        }
        super.checkCanAddColumns(transactionId, identity, tableName);
    }

    @Override
    public void checkCanDropColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DROP_COLUMN)) {
            AccessDeniedException.denyDropColumn((String)tableName.toString());
        }
        super.checkCanDropColumn(transactionId, identity, tableName);
    }

    @Override
    public void checkCanRenameColumn(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.RENAME_COLUMN)) {
            AccessDeniedException.denyRenameColumn((String)tableName.toString());
        }
        super.checkCanRenameColumn(transactionId, identity, tableName);
    }

    @Override
    public void checkCanInsertIntoTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.INSERT_TABLE)) {
            AccessDeniedException.denyInsertTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanInsertIntoTable(transactionId, identity, tableName);
        }
    }

    @Override
    public void checkCanDeleteFromTable(TransactionId transactionId, Identity identity, QualifiedObjectName tableName) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.DELETE_TABLE)) {
            AccessDeniedException.denyDeleteTable((String)tableName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDeleteFromTable(transactionId, identity, tableName);
        }
    }

    @Override
    public void checkCanCreateView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getObjectName(), TestingPrivilegeType.CREATE_VIEW)) {
            AccessDeniedException.denyCreateView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateView(transactionId, identity, viewName);
        }
    }

    @Override
    public void checkCanDropView(TransactionId transactionId, Identity identity, QualifiedObjectName viewName) {
        if (this.shouldDenyPrivilege(identity.getUser(), viewName.getObjectName(), TestingPrivilegeType.DROP_VIEW)) {
            AccessDeniedException.denyDropView((String)viewName.toString());
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanDropView(transactionId, identity, viewName);
        }
    }

    @Override
    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetSystemSessionProperty(identity, propertyName);
        }
    }

    @Override
    public void checkCanCreateViewWithSelectFromColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, Set<String> columnNames) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)) {
            AccessDeniedException.denyCreateViewWithSelect((String)tableName.toString(), (Identity)identity);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanCreateViewWithSelectFromColumns(transactionId, identity, tableName, columnNames);
        }
    }

    @Override
    public void checkCanSetCatalogSessionProperty(TransactionId transactionId, Identity identity, String catalogName, String propertyName) {
        if (this.shouldDenyPrivilege(identity.getUser(), catalogName + "." + propertyName, TestingPrivilegeType.SET_SESSION)) {
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSetCatalogSessionProperty(transactionId, identity, catalogName, propertyName);
        }
    }

    @Override
    public void checkCanSelectFromColumns(TransactionId transactionId, Identity identity, QualifiedObjectName tableName, Set<String> columns) {
        if (this.shouldDenyPrivilege(identity.getUser(), tableName.getObjectName(), TestingPrivilegeType.SELECT_COLUMN)) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        for (String column : columns) {
            if (!this.shouldDenyPrivilege(identity.getUser(), column, TestingPrivilegeType.SELECT_COLUMN)) continue;
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columns);
        }
        if (this.denyPrivileges.isEmpty()) {
            super.checkCanSelectFromColumns(transactionId, identity, tableName, columns);
        }
    }

    private boolean shouldDenyPrivilege(String userName, String entityName, TestingPrivilegeType type) {
        TestingPrivilege testPrivilege = TestingAccessControlManager.privilege(userName, entityName, type);
        for (TestingPrivilege denyPrivilege : this.denyPrivileges) {
            if (!denyPrivilege.matches(testPrivilege)) continue;
            return true;
        }
        return false;
    }

    public static class TestingPrivilege {
        private final Optional<String> userName;
        private final String entityName;
        private final TestingPrivilegeType type;

        private TestingPrivilege(Optional<String> userName, String entityName, TestingPrivilegeType type) {
            this.userName = Objects.requireNonNull(userName, "userName is null");
            this.entityName = Objects.requireNonNull(entityName, "entityName is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean matches(TestingPrivilege testPrivilege) {
            return this.userName.map(name -> testPrivilege.userName.get().equals(name)).orElse(true) != false && this.entityName.equals(testPrivilege.entityName) && this.type == testPrivilege.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingPrivilege that = (TestingPrivilege)o;
            return Objects.equals(this.entityName, that.entityName) && Objects.equals((Object)this.type, (Object)that.type);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.entityName, this.type});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userName", this.userName).add("entityName", (Object)this.entityName).add("type", (Object)this.type).toString();
        }
    }

    public static enum TestingPrivilegeType {
        SET_USER,
        CREATE_SCHEMA,
        DROP_SCHEMA,
        RENAME_SCHEMA,
        CREATE_TABLE,
        DROP_TABLE,
        RENAME_TABLE,
        COMMENT_TABLE,
        INSERT_TABLE,
        DELETE_TABLE,
        ADD_COLUMN,
        DROP_COLUMN,
        RENAME_COLUMN,
        SELECT_COLUMN,
        CREATE_VIEW,
        DROP_VIEW,
        CREATE_VIEW_WITH_SELECT_COLUMNS,
        SET_SESSION;

    }
}

