/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableMap;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.spi.eventlistener.EventListener;
import io.prestosql.spi.eventlistener.EventListenerFactory;
import io.prestosql.spi.eventlistener.QueryCompletedEvent;
import io.prestosql.spi.eventlistener.QueryCreatedEvent;
import io.prestosql.spi.eventlistener.SplitCompletedEvent;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class TestingEventListenerManager
extends EventListenerManager {
    private final AtomicReference<Optional<EventListener>> configuredEventListener = new AtomicReference(Optional.empty());

    @Override
    public void addEventListenerFactory(EventListenerFactory eventListenerFactory) {
        this.configuredEventListener.set(Optional.of(eventListenerFactory.create((Map)ImmutableMap.of())));
    }

    @Override
    public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCompleted(queryCompletedEvent);
        }
    }

    @Override
    public void queryCreated(QueryCreatedEvent queryCreatedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().queryCreated(queryCreatedEvent);
        }
    }

    @Override
    public void splitCompleted(SplitCompletedEvent splitCompletedEvent) {
        if (this.configuredEventListener.get().isPresent()) {
            this.configuredEventListener.get().get().splitCompleted(splitCompletedEvent);
        }
    }
}

