/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.connector.system.StaticSystemTablesProvider;
import io.prestosql.connector.system.SystemTablesMetadata;
import io.prestosql.execution.QueryIdGenerator;
import io.prestosql.metadata.Catalog;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.transaction.IsolationLevel;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.sql.SqlPath;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class TestingSession {
    public static final String TESTING_CATALOG = "testing_catalog";
    private static final QueryIdGenerator queryIdGenerator = new QueryIdGenerator();
    public static final TimeZoneKey DEFAULT_TIME_ZONE_KEY = TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia");

    private TestingSession() {
    }

    public static Session.SessionBuilder testSessionBuilder() {
        return TestingSession.testSessionBuilder(new SessionPropertyManager());
    }

    public static Session.SessionBuilder testSessionBuilder(SessionPropertyManager sessionPropertyManager) {
        return Session.builder(sessionPropertyManager).setQueryId(queryIdGenerator.createNextQueryId()).setIdentity(new Identity("user", Optional.empty())).setSource("test").setCatalog("catalog").setSchema("schema").setPath(new SqlPath(Optional.of("path"))).setTimeZoneKey(DEFAULT_TIME_ZONE_KEY).setLocale(Locale.ENGLISH).setRemoteUserAddress("address").setUserAgent("agent");
    }

    public static Catalog createBogusTestingCatalog(String catalogName) {
        CatalogName catalog = new CatalogName(catalogName);
        return new Catalog(catalogName, catalog, TestingSession.createTestSessionConnector(), CatalogName.createInformationSchemaCatalogName(catalog), TestingSession.createTestSessionConnector(), CatalogName.createSystemTablesCatalogName(catalog), TestingSession.createTestSessionConnector());
    }

    private static Connector createTestSessionConnector() {
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return new ConnectorTransactionHandle(){};
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new SystemTablesMetadata(new StaticSystemTablesProvider((Set<SystemTable>)ImmutableSet.of()));
            }

            public ConnectorSplitManager getSplitManager() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

