/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.testing;

import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.prestosql.Session;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskStateMachine;
import io.prestosql.memory.MemoryPool;
import io.prestosql.memory.QueryContext;
import io.prestosql.operator.TaskContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.memory.MemoryPoolId;
import io.prestosql.spiller.SpillSpaceTracker;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public final class TestingTaskContext {
    private static final GcMonitor GC_MONITOR = new TestingGcMonitor();

    private TestingTaskContext() {
    }

    public static TaskContext createTaskContext(Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session) {
        return TestingTaskContext.builder(notificationExecutor, yieldExecutor, session).build();
    }

    public static TaskContext createTaskContext(Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, DataSize maxMemory) {
        return TestingTaskContext.builder(notificationExecutor, yieldExecutor, session).setQueryMaxMemory(maxMemory).build();
    }

    public static TaskContext createTaskContext(Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session, TaskStateMachine taskStateMachine) {
        return TestingTaskContext.builder(notificationExecutor, yieldExecutor, session).setTaskStateMachine(taskStateMachine).build();
    }

    public static TaskContext createTaskContext(QueryContext queryContext, Executor executor, Session session) {
        return TestingTaskContext.createTaskContext(queryContext, session, new TaskStateMachine(new TaskId("query", 0, 0), executor));
    }

    private static TaskContext createTaskContext(QueryContext queryContext, Session session, TaskStateMachine taskStateMachine) {
        return queryContext.addTaskContext(taskStateMachine, session, true, true, OptionalInt.empty());
    }

    public static Builder builder(Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session) {
        return new Builder(notificationExecutor, yieldExecutor, session);
    }

    public static class Builder {
        private final Executor notificationExecutor;
        private final ScheduledExecutorService yieldExecutor;
        private final Session session;
        private QueryId queryId = new QueryId("test_query");
        private TaskStateMachine taskStateMachine;
        private DataSize queryMaxMemory = new DataSize(256.0, DataSize.Unit.MEGABYTE);
        private final DataSize queryMaxTotalMemory = new DataSize(512.0, DataSize.Unit.MEGABYTE);
        private DataSize memoryPoolSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
        private DataSize maxSpillSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);
        private DataSize queryMaxSpillSize = new DataSize(1.0, DataSize.Unit.GIGABYTE);

        private Builder(Executor notificationExecutor, ScheduledExecutorService yieldExecutor, Session session) {
            this.notificationExecutor = notificationExecutor;
            this.yieldExecutor = yieldExecutor;
            this.session = session;
            this.taskStateMachine = new TaskStateMachine(new TaskId("query", 0, 0), notificationExecutor);
        }

        public Builder setTaskStateMachine(TaskStateMachine taskStateMachine) {
            this.taskStateMachine = taskStateMachine;
            return this;
        }

        public Builder setQueryMaxMemory(DataSize queryMaxMemory) {
            this.queryMaxMemory = queryMaxMemory;
            return this;
        }

        public Builder setMemoryPoolSize(DataSize memoryPoolSize) {
            this.memoryPoolSize = memoryPoolSize;
            return this;
        }

        public Builder setMaxSpillSize(DataSize maxSpillSize) {
            this.maxSpillSize = maxSpillSize;
            return this;
        }

        public Builder setQueryMaxSpillSize(DataSize queryMaxSpillSize) {
            this.queryMaxSpillSize = queryMaxSpillSize;
            return this;
        }

        public Builder setQueryId(QueryId queryId) {
            this.queryId = queryId;
            return this;
        }

        public TaskContext build() {
            MemoryPool memoryPool = new MemoryPool(new MemoryPoolId("test"), this.memoryPoolSize);
            SpillSpaceTracker spillSpaceTracker = new SpillSpaceTracker(this.maxSpillSize);
            QueryContext queryContext = new QueryContext(this.queryId, this.queryMaxMemory, this.queryMaxTotalMemory, memoryPool, GC_MONITOR, this.notificationExecutor, this.yieldExecutor, this.queryMaxSpillSize, spillSpaceTracker);
            return TestingTaskContext.createTaskContext(queryContext, this.session, this.taskStateMachine);
        }
    }
}

