/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.DecimalConversions;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.TypeSignature;

public final class DecimalToDecimalCasts {
    public static final Signature SIGNATURE = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).typeVariableConstraints(Signature.withVariadicBound("F", "decimal"), Signature.withVariadicBound("T", "decimal")).argumentTypes(TypeSignature.parseTypeSignature((String)"F")).returnType(TypeSignature.parseTypeSignature((String)"T")).build();
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_CAST = SqlScalarFunction.builder(DecimalConversions.class).signature(SIGNATURE).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortToShortCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getType("F");
        DecimalType resultType = (DecimalType)context.getType("T");
        long rescale = Decimals.longTenToNth((int)Math.abs(resultType.getScale() - argumentType.getScale()));
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)rescale, (Object)(rescale / 2L));
    })).implementation(methodsGroup -> methodsGroup.methods("shortToLongCast", "longToShortCast", "longToLongCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getType("F");
        DecimalType resultType = (DecimalType)context.getType("T");
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale());
    }))).build();

    private DecimalToDecimalCasts() {
    }
}

