/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.base.Preconditions;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.ParameterKind;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeParameter;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.stream.Collectors;

public final class RowParametricType
implements ParametricType {
    public static final RowParametricType ROW = new RowParametricType();

    private RowParametricType() {
    }

    public String getName() {
        return "row";
    }

    public Type createType(TypeManager typeManager, List<TypeParameter> parameters) {
        Preconditions.checkArgument((!parameters.isEmpty() ? 1 : 0) != 0, (Object)"Row type must have at least one parameter");
        Preconditions.checkArgument((boolean)parameters.stream().allMatch(parameter -> parameter.getKind() == ParameterKind.NAMED_TYPE), (String)"Expected only named types as a parameters, got %s", parameters);
        List typeSignatureParameters = parameters.stream().map(TypeParameter::getNamedType).map(parameter -> TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(parameter.getName(), parameter.getType().getTypeSignature()))).collect(Collectors.toList());
        List fields = parameters.stream().map(TypeParameter::getNamedType).map(parameter -> new RowType.Field(parameter.getName().map(RowFieldName::getName), parameter.getType())).collect(Collectors.toList());
        return RowType.createWithTypeSignature((TypeSignature)new TypeSignature("row", typeSignatureParameters), fields);
    }
}

