/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.SmallintType;

public final class SmallintOperators {
    private SmallintOperators() {
    }

    @ScalarOperator(value=OperatorType.ADD)
    @SqlType(value="smallint")
    public static long add(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        try {
            return Shorts.checkedCast((long)(left + right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("smallint addition overflow: %s + %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="smallint")
    public static long subtract(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        try {
            return Shorts.checkedCast((long)(left - right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("smallint subtraction overflow: %s - %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MULTIPLY)
    @SqlType(value="smallint")
    public static long multiply(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        try {
            return Shorts.checkedCast((long)(left * right));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("smallint multiplication overflow: %s * %s", left, right), (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.DIVIDE)
    @SqlType(value="smallint")
    public static long divide(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        try {
            return left / right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.MODULUS)
    @SqlType(value="smallint")
    public static long modulus(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        try {
            return left % right;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, "Division by zero", (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    @SqlType(value="smallint")
    public static long negate(@SqlType(value="smallint") long value) {
        try {
            return Shorts.checkedCast((long)(-value));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "smallint negation overflow: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left < right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left <= right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left > right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="smallint") long left, @SqlType(value="smallint") long right) {
        return left >= right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="smallint") long value, @SqlType(value="smallint") long min, @SqlType(value="smallint") long max) {
        return min <= value && value <= max;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="smallint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="smallint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="smallint") long value) {
        try {
            return SignedBytes.checkedCast((long)value);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Out of range for tinyint: " + value, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="boolean")
    public static boolean castToBoolean(@SqlType(value="smallint") long value) {
        return value != 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="smallint") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="real")
    public static long castToReal(@SqlType(value="smallint") long value) {
        return Float.floatToRawIntBits(value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="smallint") long value) {
        return Slices.utf8Slice((String)String.valueOf(value));
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="smallint") long value) {
        return SmallintType.hash((short)((short)value));
    }

    @ScalarOperator(value=OperatorType.SATURATED_FLOOR_CAST)
    @SqlType(value="tinyint")
    public static long saturatedFloorCastToTinyint(@SqlType(value="smallint") long value) {
        return SignedBytes.saturatedCast((long)value);
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="smallint") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="smallint") long value) {
        return XxHash64.hash((long)value);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class SmallintDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="smallint") long left, @IsNull boolean leftNull, @SqlType(value="smallint") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return SmallintOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="smallint", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="smallint", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return SmallintOperators.notEqual(SmallintType.SMALLINT.getLong(left, leftPosition), SmallintType.SMALLINT.getLong(right, rightPosition));
        }
    }
}

