/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.slice.XxHash64;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.AbstractLongType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeWithTimeZoneType;
import io.prestosql.util.DateTimeUtils;
import io.prestosql.util.DateTimeZoneIndex;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import org.joda.time.chrono.ISOChronology;

public final class TimeWithTimeZoneOperators {
    private static final long REFERENCE_TIMESTAMP_UTC = System.currentTimeMillis();

    private TimeWithTimeZoneOperators() {
    }

    @ScalarOperator(value=OperatorType.SUBTRACT)
    @SqlType(value="interval day to second")
    public static long subtract(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) - DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equal(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) == DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) != DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) < DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) <= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) > DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="time with time zone") long left, @SqlType(value="time with time zone") long right) {
        return DateTimeEncoding.unpackMillisUtc((long)left) >= DateTimeEncoding.unpackMillisUtc((long)right);
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="time with time zone") long value, @SqlType(value="time with time zone") long min, @SqlType(value="time with time zone") long max) {
        return DateTimeEncoding.unpackMillisUtc((long)min) <= DateTimeEncoding.unpackMillisUtc((long)value) && DateTimeEncoding.unpackMillisUtc((long)value) <= DateTimeEncoding.unpackMillisUtc((long)max);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="time")
    public static long castToTime(ConnectorSession session, @SqlType(value="time with time zone") long value) {
        return TimeWithTimeZoneOperators.castToTimestamp(session, value);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp")
    public static long castToTimestamp(ConnectorSession session, @SqlType(value="time with time zone") long value) {
        if (session.isLegacyTimestamp()) {
            return DateTimeEncoding.unpackMillisUtc((long)value);
        }
        long currentMillisOfDay = ChronoField.MILLI_OF_DAY.getFrom(Instant.ofEpochMilli(REFERENCE_TIMESTAMP_UTC).atZone(ZoneOffset.UTC));
        long timeMillisUtcInCurrentDay = REFERENCE_TIMESTAMP_UTC - currentMillisOfDay + DateTimeEncoding.unpackMillisUtc((long)value);
        ISOChronology chronology = DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)value));
        return DateTimeEncoding.unpackMillisUtc((long)value) + (long)chronology.getZone().getOffset(timeMillisUtcInCurrentDay);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="timestamp with time zone")
    public static long castToTimestampWithTimeZone(@SqlType(value="time with time zone") long value) {
        return value;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToSlice(@SqlType(value="time with time zone") long value) {
        return Slices.utf8Slice((String)DateTimeUtils.printTimeWithTimeZone(value));
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="time with time zone")
    public static long castFromSlice(@SqlType(value="varchar(x)") Slice value) {
        return DateTimeUtils.parseTimeWithTimeZone(value.toStringUtf8());
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="time with time zone") long value) {
        return AbstractLongType.hash((long)DateTimeEncoding.unpackMillisUtc((long)value));
    }

    @ScalarOperator(value=OperatorType.XX_HASH_64)
    @SqlType(value="bigint")
    public static long xxHash64(@SqlType(value="time with time zone") long value) {
        return XxHash64.hash((long)DateTimeEncoding.unpackMillisUtc((long)value));
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="time with time zone") long value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class TimeWithTimeZoneDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="time with time zone") long left, @IsNull boolean leftNull, @SqlType(value="time with time zone") long right, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return TimeWithTimeZoneOperators.notEqual(left, right);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="time with time zone", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="time with time zone", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
            if (left.isNull(leftPosition) && right.isNull(rightPosition)) {
                return false;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            return TimeWithTimeZoneOperators.notEqual(TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getLong(left, leftPosition), TimeWithTimeZoneType.TIME_WITH_TIME_ZONE.getLong(right, rightPosition));
        }
    }
}

