/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.FromStringDeserializer;
import com.google.common.base.Preconditions;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeSignature;
import java.util.Objects;
import javax.inject.Inject;

public final class TypeDeserializer
extends FromStringDeserializer<Type> {
    private final TypeManager typeManager;

    @Inject
    public TypeDeserializer(TypeManager typeManager) {
        super(Type.class);
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    protected Type _deserialize(String value, DeserializationContext context) {
        Type type = this.typeManager.getType(TypeSignature.parseTypeSignature((String)value));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Unknown type %s", (Object)value);
        return type;
    }
}

