/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.type.setdigest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import io.prestosql.type.setdigest.SetDigest;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public final class SetDigestFunctions {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();

    private SetDigestFunctions() {
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long cardinality(@SqlType(value="SetDigest") Slice digest) {
        return SetDigest.newInstance(digest).cardinality();
    }

    @ScalarFunction
    @SqlType(value="bigint")
    public static long intersectionCardinality(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        if (digest1.isExact() && digest2.isExact()) {
            return SetDigest.exactIntersectionCardinality(digest1, digest2);
        }
        long cardinality1 = digest1.cardinality();
        long cardinality2 = digest2.cardinality();
        double jaccard = SetDigest.jaccardIndex(digest1, digest2);
        digest1.mergeWith(digest2);
        long result = Math.round(jaccard * (double)digest1.cardinality());
        return Math.min(result, Math.min(cardinality1, cardinality2));
    }

    @ScalarFunction
    @SqlType(value="double")
    public static double jaccardIndex(@SqlType(value="SetDigest") Slice slice1, @SqlType(value="SetDigest") Slice slice2) {
        SetDigest digest1 = SetDigest.newInstance(slice1);
        SetDigest digest2 = SetDigest.newInstance(slice2);
        return SetDigest.jaccardIndex(digest1, digest2);
    }

    @ScalarFunction
    @SqlType(value="map(bigint,smallint)")
    public static Block hashCounts(@TypeParameter(value="map<bigint,smallint>") Type mapType, @SqlType(value="SetDigest") Slice slice) {
        SetDigest digest = SetDigest.newInstance(slice);
        BlockBuilder blockBuilder = mapType.createBlockBuilder(null, 1);
        BlockBuilder singleMapBlockBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry<Long, Short> entry : digest.getHashCounts().entrySet()) {
            BigintType.BIGINT.writeLong(singleMapBlockBuilder, entry.getKey().longValue());
            SmallintType.SMALLINT.writeLong(singleMapBlockBuilder, (long)entry.getValue().shortValue());
        }
        blockBuilder.closeEntry();
        return (Block)mapType.getObject((Block)blockBuilder, 0);
    }

    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice hashCounts(@SqlType(value="SetDigest") Slice slice) {
        SetDigest digest = SetDigest.newInstance(slice);
        try {
            return Slices.utf8Slice((String)OBJECT_MAPPER.writeValueAsString(digest.getHashCounts()));
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }
}

