/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.util;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.prestosql.client.ErrorLocation;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Failure;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.PrestoTransportException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.analyzer.SemanticException;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.tree.NodeLocation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class Failures {
    private static final String NODE_CRASHED_ERROR = "The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String WORKER_NODE_ERROR = "Encountered too many errors talking to a worker node. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";
    public static final String REMOTE_TASK_MISMATCH_ERROR = "Could not communicate with the remote task. The node may have crashed or be under too much load. This is probably a transient issue, so please retry your query in a few minutes.";

    private Failures() {
    }

    public static ExecutionFailureInfo toFailure(Throwable failure) {
        return Failures.toFailure(failure, Sets.newIdentityHashSet());
    }

    public static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String formatString, Object ... args) {
        if (!condition) {
            throw new PrestoException(errorCode, String.format(formatString, args));
        }
    }

    public static List<ExecutionFailureInfo> toFailures(Collection<? extends Throwable> failures) {
        return (List)failures.stream().map(Failures::toFailure).collect(ImmutableList.toImmutableList());
    }

    private static ExecutionFailureInfo toFailure(Throwable throwable, Set<Throwable> seenFailures) {
        String type;
        if (throwable == null) {
            return null;
        }
        HostAddress remoteHost = null;
        if (throwable instanceof Failure) {
            type = ((Failure)throwable).getType();
        } else {
            Class<?> clazz = throwable.getClass();
            type = (String)MoreObjects.firstNonNull((Object)clazz.getCanonicalName(), (Object)clazz.getName());
        }
        if (throwable instanceof PrestoTransportException) {
            remoteHost = ((PrestoTransportException)throwable).getRemoteHost();
        }
        if (seenFailures.contains(throwable)) {
            return new ExecutionFailureInfo(type, "[cyclic] " + throwable.getMessage(), null, (List<ExecutionFailureInfo>)ImmutableList.of(), (List<String>)ImmutableList.of(), null, StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode(), remoteHost);
        }
        seenFailures.add(throwable);
        ExecutionFailureInfo cause = Failures.toFailure(throwable.getCause(), seenFailures);
        ErrorCode errorCode = Failures.toErrorCode(throwable);
        if (errorCode == null) {
            errorCode = cause == null ? StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode() : cause.getErrorCode();
        }
        return new ExecutionFailureInfo(type, throwable.getMessage(), cause, (List)Arrays.stream(throwable.getSuppressed()).map(failure -> Failures.toFailure(failure, seenFailures)).collect(ImmutableList.toImmutableList()), Lists.transform(Arrays.asList(throwable.getStackTrace()), (Function)Functions.toStringFunction()), Failures.getErrorLocation(throwable), errorCode, remoteHost);
    }

    @Nullable
    private static ErrorLocation getErrorLocation(Throwable throwable) {
        SemanticException e;
        if (throwable instanceof ParsingException) {
            ParsingException e2 = (ParsingException)throwable;
            return new ErrorLocation(e2.getLineNumber(), e2.getColumnNumber());
        }
        if (throwable instanceof SemanticException && (e = (SemanticException)throwable).getNode().getLocation().isPresent()) {
            NodeLocation nodeLocation = (NodeLocation)e.getNode().getLocation().get();
            return new ErrorLocation(nodeLocation.getLineNumber(), nodeLocation.getColumnNumber());
        }
        return null;
    }

    @Nullable
    private static ErrorCode toErrorCode(Throwable throwable) {
        Objects.requireNonNull(throwable);
        if (throwable instanceof PrestoException) {
            return ((PrestoException)throwable).getErrorCode();
        }
        if (throwable instanceof Failure && ((Failure)throwable).getErrorCode() != null) {
            return ((Failure)throwable).getErrorCode();
        }
        if (throwable instanceof ParsingException || throwable instanceof SemanticException) {
            return StandardErrorCode.SYNTAX_ERROR.toErrorCode();
        }
        return null;
    }

    public static PrestoException internalError(Throwable t) {
        Throwables.throwIfInstanceOf((Throwable)t, Error.class);
        Throwables.throwIfInstanceOf((Throwable)t, PrestoException.class);
        return new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
    }
}

