/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector;

import com.google.common.collect.ImmutableSet;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.spi.Node;
import io.prestosql.spi.NodeManager;
import java.util.Objects;
import java.util.Set;

public class ConnectorAwareNodeManager
implements NodeManager {
    private final InternalNodeManager nodeManager;
    private final String environment;
    private final CatalogName catalogName;

    public ConnectorAwareNodeManager(InternalNodeManager nodeManager, String environment, CatalogName catalogName) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public Set<Node> getAllNodes() {
        return ImmutableSet.builder().addAll(this.getWorkerNodes()).addAll(this.nodeManager.getCoordinators()).build();
    }

    public Set<Node> getWorkerNodes() {
        return ImmutableSet.copyOf(this.nodeManager.getActiveConnectorNodes(this.catalogName));
    }

    public Node getCurrentNode() {
        return this.nodeManager.getCurrentNode();
    }

    public String getEnvironment() {
        return this.environment;
    }
}

