/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.scheduler.NetworkLocation;
import io.prestosql.execution.scheduler.NodeMap;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.execution.scheduler.NodeSelector;
import io.prestosql.execution.scheduler.NodeSelectorFactory;
import io.prestosql.execution.scheduler.UniformNodeSelector;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.NodeState;
import io.prestosql.spi.HostAddress;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class UniformNodeSelectorFactory
implements NodeSelectorFactory {
    private static final Logger LOG = Logger.get(UniformNodeSelectorFactory.class);
    private final Cache<InternalNode, Boolean> inaccessibleNodeLogCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final InternalNodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final int maxSplitsPerNode;
    private final int maxPendingSplitsPerTask;
    private final boolean optimizedLocalScheduling;
    private final NodeTaskMap nodeTaskMap;

    @Inject
    public UniformNodeSelectorFactory(InternalNodeManager nodeManager, NodeSchedulerConfig config, NodeTaskMap nodeTaskMap) {
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        this.nodeManager = nodeManager;
        this.minCandidates = config.getMinCandidates();
        this.includeCoordinator = config.isIncludeCoordinator();
        this.maxSplitsPerNode = config.getMaxSplitsPerNode();
        this.maxPendingSplitsPerTask = config.getMaxPendingSplitsPerTask();
        this.optimizedLocalScheduling = config.getOptimizedLocalScheduling();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Preconditions.checkArgument((this.maxSplitsPerNode >= this.maxPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxPendingSplitsPerTask");
    }

    @Override
    public NodeSelector createNodeSelector(Optional<CatalogName> catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Supplier nodeMap = Suppliers.memoizeWithExpiration(() -> this.createNodeMap(catalogName), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        return new UniformNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, (java.util.function.Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsPerNode, this.maxPendingSplitsPerTask, this.optimizedLocalScheduling);
    }

    private NodeMap createNodeMap(Optional<CatalogName> catalogName) {
        Set nodes = catalogName.map(this.nodeManager::getActiveConnectorNodes).orElseGet(() -> this.nodeManager.getNodes(NodeState.ACTIVE));
        Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
        for (InternalNode node : nodes) {
            try {
                byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                InetAddress host = InetAddress.getByName(node.getInternalUri().getHost());
                byHost.put((Object)host, (Object)node);
            }
            catch (UnknownHostException e) {
                if (this.inaccessibleNodeLogCache.getIfPresent((Object)node) != null) continue;
                this.inaccessibleNodeLogCache.put((Object)node, (Object)true);
                LOG.warn((Throwable)e, "Unable to resolve host name for node: %s", new Object[]{node});
            }
        }
        return new NodeMap((SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)ImmutableSetMultimap.of(), coordinatorNodeIds);
    }
}

