/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.prestosql.spi.type.NamedTypeSignature;
import io.prestosql.spi.type.RowFieldName;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class TypeSignatureParser {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("[a-zA-Z_]([a-zA-Z0-9_:@])*");
    private static final Set<String> SIMPLE_TYPE_WITH_SPACES = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

    private TypeSignatureParser() {
    }

    public static TypeSignature parseTypeSignature(String signature, Set<String> literalCalculationParameters) {
        if (!signature.contains("<") && !signature.contains("(")) {
            if (signature.equalsIgnoreCase("varchar")) {
                return VarcharType.createUnboundedVarcharType().getTypeSignature();
            }
            Preconditions.checkArgument((!literalCalculationParameters.contains(signature) ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
            return new TypeSignature(signature, new ArrayList());
        }
        if (signature.toLowerCase(Locale.ENGLISH).startsWith("row(")) {
            return TypeSignatureParser.parseRowTypeSignature(signature, literalCalculationParameters);
        }
        String baseName = null;
        ArrayList<TypeSignatureParameter> parameters = new ArrayList<TypeSignatureParameter>();
        int parameterStart = -1;
        int bracketCount = 0;
        for (int i = 0; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            if (c == '(') {
                if (bracketCount == 0) {
                    Verify.verify((baseName == null ? 1 : 0) != 0, (String)"Expected baseName to be null", (Object[])new Object[0]);
                    Verify.verify((parameterStart == -1 ? 1 : 0) != 0, (String)"Expected parameter start to be -1", (Object[])new Object[0]);
                    baseName = signature.substring(0, i);
                    Preconditions.checkArgument((!literalCalculationParameters.contains(baseName) ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
                    parameterStart = i + 1;
                }
                ++bracketCount;
                continue;
            }
            if (c == ')') {
                Preconditions.checkArgument((--bracketCount >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
                if (bracketCount != 0) continue;
                Preconditions.checkArgument((parameterStart >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
                parameters.add(TypeSignatureParser.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters));
                parameterStart = i + 1;
                if (i != signature.length() - 1) continue;
                return new TypeSignature(baseName, parameters);
            }
            if (c != ',' || bracketCount != 1) continue;
            Preconditions.checkArgument((parameterStart >= 0 ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
            parameters.add(TypeSignatureParser.parseTypeSignatureParameter(signature, parameterStart, i, literalCalculationParameters));
            parameterStart = i + 1;
        }
        throw new IllegalArgumentException(String.format("Bad type signature: '%s'", signature));
    }

    private static TypeSignature parseRowTypeSignature(String signature, Set<String> literalParameters) {
        Preconditions.checkArgument((boolean)signature.toLowerCase(Locale.ENGLISH).startsWith("row("), (String)"Not a row type signature: '%s'", (Object)signature);
        RowTypeSignatureParsingState state = RowTypeSignatureParsingState.START_OF_FIELD;
        int bracketLevel = 1;
        int tokenStart = -1;
        String delimitedColumnName = null;
        ArrayList<TypeSignatureParameter> fields = new ArrayList<TypeSignatureParameter>();
        block8: for (int i = "row".length() + 1; i < signature.length(); ++i) {
            char c = signature.charAt(i);
            switch (state) {
                case START_OF_FIELD: {
                    if (c == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME;
                        tokenStart = i;
                        continue block8;
                    }
                    if (TypeSignatureParser.isValidStartOfIdentifier(c)) {
                        state = RowTypeSignatureParsingState.TYPE_OR_NAMED_TYPE;
                        tokenStart = i;
                        continue block8;
                    }
                    Preconditions.checkArgument((c == ' ' ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
                    continue block8;
                }
                case DELIMITED_NAME: {
                    if (c != '\"') continue block8;
                    if (i + 1 < signature.length() && signature.charAt(i + 1) == '\"') {
                        state = RowTypeSignatureParsingState.DELIMITED_NAME_ESCAPED;
                        continue block8;
                    }
                    Verify.verify((tokenStart >= 0 ? 1 : 0) != 0, (String)"Expect tokenStart to be non-negative", (Object[])new Object[0]);
                    delimitedColumnName = signature.substring(tokenStart + 1, i);
                    tokenStart = i + 1;
                    state = RowTypeSignatureParsingState.TYPE;
                    continue block8;
                }
                case DELIMITED_NAME_ESCAPED: {
                    Verify.verify((c == '\"' ? 1 : 0) != 0, (String)"Expect quote after escape", (Object[])new Object[0]);
                    state = RowTypeSignatureParsingState.DELIMITED_NAME;
                    continue block8;
                }
                case TYPE_OR_NAMED_TYPE: {
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        Verify.verify((tokenStart >= 0 ? 1 : 0) != 0, (String)"Expect tokenStart to be non-negative", (Object[])new Object[0]);
                        fields.add(TypeSignatureParser.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters));
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    Verify.verify((tokenStart >= 0 ? 1 : 0) != 0, (String)"Expect tokenStart to be non-negative", (Object[])new Object[0]);
                    fields.add(TypeSignatureParser.parseTypeOrNamedType(signature.substring(tokenStart, i).trim(), literalParameters));
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case TYPE: {
                    if (c == '(') {
                        ++bracketLevel;
                        continue block8;
                    }
                    if (c == ')' && bracketLevel > 1) {
                        --bracketLevel;
                        continue block8;
                    }
                    if (c == ')') {
                        Verify.verify((tokenStart >= 0 ? 1 : 0) != 0, (String)"Expect tokenStart to be non-negative", (Object[])new Object[0]);
                        Verify.verify((delimitedColumnName != null ? 1 : 0) != 0, (String)"Expect delimitedColumnName to be non-null", (Object[])new Object[0]);
                        fields.add(TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName)), TypeSignatureParser.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                        delimitedColumnName = null;
                        tokenStart = -1;
                        state = RowTypeSignatureParsingState.FINISHED;
                        continue block8;
                    }
                    if (c != ',' || bracketLevel != 1) continue block8;
                    Verify.verify((tokenStart >= 0 ? 1 : 0) != 0, (String)"Expect tokenStart to be non-negative", (Object[])new Object[0]);
                    Verify.verify((delimitedColumnName != null ? 1 : 0) != 0, (String)"Expect delimitedColumnName to be non-null", (Object[])new Object[0]);
                    fields.add(TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(delimitedColumnName)), TypeSignatureParser.parseTypeSignature(signature.substring(tokenStart, i).trim(), literalParameters))));
                    delimitedColumnName = null;
                    tokenStart = -1;
                    state = RowTypeSignatureParsingState.START_OF_FIELD;
                    continue block8;
                }
                case FINISHED: {
                    throw new IllegalStateException(String.format("Bad type signature: '%s'", signature));
                }
                default: {
                    throw new AssertionError((Object)String.format("Unexpected RowTypeSignatureParsingState: %s", new Object[]{state}));
                }
            }
        }
        Preconditions.checkArgument((state == RowTypeSignatureParsingState.FINISHED ? 1 : 0) != 0, (String)"Bad type signature: '%s'", (Object)signature);
        return new TypeSignature(signature.substring(0, "row".length()), fields);
    }

    private static TypeSignatureParameter parseTypeOrNamedType(String typeOrNamedType, Set<String> literalParameters) {
        int split = typeOrNamedType.indexOf(32);
        if (split == -1 || SIMPLE_TYPE_WITH_SPACES.contains(typeOrNamedType)) {
            return TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignatureParser.parseTypeSignature(typeOrNamedType, literalParameters)));
        }
        String firstPart = typeOrNamedType.substring(0, split);
        if (IDENTIFIER_PATTERN.matcher(firstPart).matches()) {
            return TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.of(new RowFieldName(firstPart)), TypeSignatureParser.parseTypeSignature(typeOrNamedType.substring(split + 1).trim(), literalParameters)));
        }
        return TypeSignatureParameter.namedTypeParameter((NamedTypeSignature)new NamedTypeSignature(Optional.empty(), TypeSignatureParser.parseTypeSignature(typeOrNamedType, literalParameters)));
    }

    private static TypeSignatureParameter parseTypeSignatureParameter(String signature, int begin, int end, Set<String> literalCalculationParameters) {
        String parameterName = signature.substring(begin, end).trim();
        if (Character.isDigit(signature.charAt(begin))) {
            return TypeSignatureParameter.numericParameter((long)Long.parseLong(parameterName));
        }
        if (literalCalculationParameters.contains(parameterName)) {
            return TypeSignatureParameter.typeVariable((String)parameterName);
        }
        return TypeSignatureParameter.typeParameter((TypeSignature)TypeSignatureParser.parseTypeSignature(parameterName, literalCalculationParameters));
    }

    private static boolean isValidStartOfIdentifier(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    static {
        SIMPLE_TYPE_WITH_SPACES.add("time with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("timestamp with time zone");
        SIMPLE_TYPE_WITH_SPACES.add("interval day to second");
        SIMPLE_TYPE_WITH_SPACES.add("interval year to month");
        SIMPLE_TYPE_WITH_SPACES.add("double precision");
    }

    private static enum RowTypeSignatureParsingState {
        START_OF_FIELD,
        DELIMITED_NAME,
        DELIMITED_NAME_ESCAPED,
        TYPE_OR_NAMED_TYPE,
        TYPE,
        FINISHED;

    }
}

