/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.multimapagg;

import io.prestosql.operator.aggregation.multimapagg.GroupedMultimapAggregationState;
import io.prestosql.operator.aggregation.multimapagg.LegacyGroupedMultimapAggregationState;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import io.prestosql.operator.aggregation.multimapagg.MultimapAggregationState;
import io.prestosql.operator.aggregation.multimapagg.SingleMultimapAggregationState;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.type.Type;
import java.util.Objects;

public class MultimapAggregationStateFactory
implements AccumulatorStateFactory<MultimapAggregationState> {
    private final Type keyType;
    private final Type valueType;
    private final MultimapAggGroupImplementation implementation;

    public MultimapAggregationStateFactory(Type keyType, Type valueType, MultimapAggGroupImplementation implementation) {
        this.keyType = Objects.requireNonNull(keyType);
        this.valueType = Objects.requireNonNull(valueType);
        this.implementation = Objects.requireNonNull(implementation);
    }

    public MultimapAggregationState createSingleState() {
        return new SingleMultimapAggregationState(this.keyType, this.valueType);
    }

    public Class<? extends MultimapAggregationState> getSingleStateClass() {
        return SingleMultimapAggregationState.class;
    }

    public MultimapAggregationState createGroupedState() {
        switch (this.implementation) {
            case NEW: {
                return new GroupedMultimapAggregationState(this.keyType, this.valueType);
            }
            case LEGACY: {
                return new LegacyGroupedMultimapAggregationState(this.keyType, this.valueType);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.implementation}));
    }

    public Class<? extends MultimapAggregationState> getGroupedStateClass() {
        switch (this.implementation) {
            case NEW: {
                return GroupedMultimapAggregationState.class;
            }
            case LEGACY: {
                return LegacyGroupedMultimapAggregationState.class;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.implementation}));
    }
}

