/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.annotations;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.TypeSignatureParser;
import io.prestosql.operator.annotations.CastImplementationDependency;
import io.prestosql.operator.annotations.ImplementationDependency;
import io.prestosql.operator.annotations.OperatorImplementationDependency;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameterSpecialization;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.type.Constraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class FunctionsParserHelper {
    private static final Set<OperatorType> COMPARABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.EQUAL, (Object)OperatorType.NOT_EQUAL, (Object)OperatorType.HASH_CODE, (Object)OperatorType.XX_HASH_64, (Object)OperatorType.IS_DISTINCT_FROM, (Object)OperatorType.INDETERMINATE, (Object[])new OperatorType[0]);
    private static final Set<OperatorType> ORDERABLE_TYPE_OPERATORS = ImmutableSet.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL, (Object)OperatorType.BETWEEN);

    private FunctionsParserHelper() {
    }

    public static boolean containsAnnotation(Annotation[] annotations, Predicate<Annotation> predicate) {
        return Arrays.stream(annotations).anyMatch(predicate);
    }

    public static boolean containsImplementationDependencyAnnotation(Annotation[] annotations) {
        return FunctionsParserHelper.containsAnnotation(annotations, ImplementationDependency::isImplementationDependencyAnnotation);
    }

    public static List<TypeVariableConstraint> createTypeVariableConstraints(Collection<TypeParameter> typeParameters, List<ImplementationDependency> dependencies) {
        Set typeParameterNames = (Set)typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
        HashSet<String> orderableRequired = new HashSet<String>();
        HashSet<String> comparableRequired = new HashSet<String>();
        HashMultimap castableTo = HashMultimap.create();
        HashMultimap castableFrom = HashMultimap.create();
        for (ImplementationDependency dependency : dependencies) {
            if (dependency instanceof OperatorImplementationDependency) {
                TypeSignature typeSignature;
                OperatorImplementationDependency operatorDependency = (OperatorImplementationDependency)dependency;
                OperatorType operator = operatorDependency.getOperator();
                List<TypeSignature> argumentTypes = operatorDependency.getArgumentTypes();
                if (COMPARABLE_TYPE_OPERATORS.contains(operator)) {
                    FunctionsParserHelper.verifyOperatorSignature(operator, argumentTypes);
                    typeSignature = argumentTypes.get(0);
                    if (typeParameterNames.contains(typeSignature.getBase())) {
                        comparableRequired.add(typeSignature.toString());
                        continue;
                    }
                    FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(typeSignature, typeSignature, typeParameterNames);
                    continue;
                }
                if (ORDERABLE_TYPE_OPERATORS.contains(operator)) {
                    FunctionsParserHelper.verifyOperatorSignature(operator, argumentTypes);
                    typeSignature = argumentTypes.get(0);
                    if (typeParameterNames.contains(typeSignature.getBase())) {
                        orderableRequired.add(typeSignature.toString());
                        continue;
                    }
                    FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(typeSignature, typeSignature, typeParameterNames);
                    continue;
                }
                throw new IllegalArgumentException("Operator dependency on " + operator + " is not allowed");
            }
            if (!(dependency instanceof CastImplementationDependency)) continue;
            CastImplementationDependency castImplementationDependency = (CastImplementationDependency)dependency;
            TypeSignature fromType = castImplementationDependency.getFromType();
            TypeSignature toType = castImplementationDependency.getToType();
            if (typeParameterNames.contains(fromType.getBase())) {
                castableTo.put((Object)fromType.toString(), (Object)toType.toString());
                continue;
            }
            if (typeParameterNames.contains(toType.getBase())) {
                castableFrom.put((Object)toType.toString(), (Object)fromType.toString());
                continue;
            }
            FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(fromType, fromType, typeParameterNames);
            FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(toType, toType, typeParameterNames);
        }
        ImmutableList.Builder typeVariableConstraints = ImmutableList.builder();
        for (String name : typeParameterNames) {
            typeVariableConstraints.add((Object)new TypeVariableConstraint(name, comparableRequired.contains(name), orderableRequired.contains(name), null, (Set)castableTo.get((Object)name).stream().map(type -> TypeSignatureParser.parseTypeSignature(type, typeParameterNames)).collect(ImmutableSet.toImmutableSet()), (Set)castableFrom.get((Object)name).stream().map(type -> TypeSignatureParser.parseTypeSignature(type, typeParameterNames)).collect(ImmutableSet.toImmutableSet())));
        }
        return typeVariableConstraints.build();
    }

    private static void verifyOperatorSignature(OperatorType operator, List<TypeSignature> argumentTypes) {
        Preconditions.checkArgument((argumentTypes.size() == operator.getArgumentCount() && argumentTypes.stream().distinct().count() == 1L ? 1 : 0) != 0, (String)"%s requires %s arguments of the same type", (Object)operator, (int)operator.getArgumentCount());
    }

    private static void verifyTypeSignatureDoesNotContainAnyTypeParameters(TypeSignature rootType, TypeSignature typeSignature, Set<String> typeParameterNames) {
        Preconditions.checkArgument((!typeParameterNames.contains(typeSignature.getBase()) ? 1 : 0) != 0, (String)"Nested type variables are not allowed: %s", (Object)rootType);
        block5: for (TypeSignatureParameter parameter : typeSignature.getParameters()) {
            switch (parameter.getKind()) {
                case TYPE: {
                    FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(rootType, parameter.getTypeSignature(), typeParameterNames);
                    continue block5;
                }
                case NAMED_TYPE: {
                    FunctionsParserHelper.verifyTypeSignatureDoesNotContainAnyTypeParameters(rootType, parameter.getNamedTypeSignature().getTypeSignature(), typeParameterNames);
                    continue block5;
                }
                case LONG: 
                case VARIABLE: {
                    continue block5;
                }
            }
            throw new UnsupportedOperationException();
        }
    }

    public static void validateSignaturesCompatibility(Optional<Signature> signatureOld, Signature signatureNew) {
        if (!signatureOld.isPresent()) {
            return;
        }
        Preconditions.checkArgument((boolean)signatureOld.get().equals(signatureNew), (String)"Implementations with type parameters must all have matching signatures. %s does not match %s", (Object)signatureOld.get(), (Object)signatureNew);
    }

    public static List<Method> findPublicStaticMethodsWithAnnotation(Class<?> clazz, Class<?> annotationClass) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Method method : clazz.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotationClass.isInstance(annotation)) continue;
                Preconditions.checkArgument((Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) ? 1 : 0) != 0, (String)"%s annotated with %s must be static and public", (Object)method.getName(), (Object)annotationClass.getSimpleName());
                methods.add((Object)method);
            }
        }
        return methods.build();
    }

    @SafeVarargs
    public static Set<Method> findPublicMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> ... annotationClasses) {
        ImmutableSet.Builder methods = ImmutableSet.builder();
        for (Method method : clazz.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                for (Class<? extends Annotation> annotationClass : annotationClasses) {
                    if (!annotationClass.isInstance(annotation)) continue;
                    Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"Method [%s] annotated with @%s must be public", (Object)method, (Object)annotationClass.getSimpleName());
                    methods.add((Object)method);
                }
            }
        }
        return methods.build();
    }

    public static Optional<Constructor<?>> findConstructor(Class<?> clazz) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Preconditions.checkArgument((constructors.length <= 1 ? 1 : 0) != 0, (String)"Class [%s] must have no more than 1 public constructor", (Object)clazz.getName());
        if (constructors.length == 0) {
            return Optional.empty();
        }
        return Optional.of(constructors[0]);
    }

    public static Set<String> parseLiteralParameters(Method method) {
        LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
        if (literalParametersAnnotation == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])literalParametersAnnotation.value());
    }

    public static boolean containsLegacyNullable(Annotation[] annotations) {
        return Arrays.stream(annotations).map(Annotation::annotationType).map(Class::getName).anyMatch(name -> name.equals(Nullable.class.getName()));
    }

    public static boolean isPrestoAnnotation(Annotation annotation) {
        return ImplementationDependency.isImplementationDependencyAnnotation(annotation) || annotation instanceof SqlType || annotation instanceof SqlNullable || annotation instanceof IsNull;
    }

    public static Optional<String> parseDescription(AnnotatedElement base, AnnotatedElement override) {
        Optional<String> overrideDescription = FunctionsParserHelper.parseDescription(override);
        if (overrideDescription.isPresent()) {
            return overrideDescription;
        }
        return FunctionsParserHelper.parseDescription(base);
    }

    public static Optional<String> parseDescription(AnnotatedElement base) {
        Description description = base.getAnnotation(Description.class);
        return description == null ? Optional.empty() : Optional.of(description.value());
    }

    public static List<LongVariableConstraint> parseLongVariableConstraints(Method inputFunction) {
        return (List)Stream.of(inputFunction.getAnnotationsByType(Constraint.class)).map(annotation -> new LongVariableConstraint(annotation.variable(), annotation.expression())).collect(ImmutableList.toImmutableList());
    }

    public static Map<String, Class<?>> getDeclaredSpecializedTypeParameters(Method method, Set<TypeParameter> typeParameters) {
        HashMap specializedTypeParameters = new HashMap();
        TypeParameterSpecialization[] typeParameterSpecializations = (TypeParameterSpecialization[])method.getAnnotationsByType(TypeParameterSpecialization.class);
        ImmutableSet typeParameterNames = (ImmutableSet)typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
        for (TypeParameterSpecialization specialization : typeParameterSpecializations) {
            Preconditions.checkArgument((boolean)typeParameterNames.contains((Object)specialization.name()), (String)"%s does not match any declared type parameters (%s) [%s]", (Object)specialization.name(), typeParameters, (Object)method);
            Class existingSpecialization = (Class)specializedTypeParameters.get(specialization.name());
            Preconditions.checkArgument((existingSpecialization == null || existingSpecialization.equals(specialization.nativeContainerType()) ? 1 : 0) != 0, (String)"%s has conflicting specializations %s and %s [%s]", (Object)specialization.name(), (Object)existingSpecialization, (Object)specialization.nativeContainerType(), (Object)method);
            specializedTypeParameters.put(specialization.name(), specialization.nativeContainerType());
        }
        return specializedTypeParameters;
    }
}

