/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import com.google.common.base.VerifyException;
import com.google.common.collect.Lists;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.window.AbstractWindowFunctionSupplier;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.ValueWindowFunction;
import io.prestosql.spi.function.WindowFunction;
import io.prestosql.spi.type.Type;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Objects;

public class ReflectionWindowFunctionSupplier<T extends WindowFunction>
extends AbstractWindowFunctionSupplier {
    private final Constructor<T> constructor;
    private final ConstructorType constructorType;

    public ReflectionWindowFunctionSupplier(String name, Type returnType, List<? extends Type> argumentTypes, Class<T> type) {
        this(new Signature(name, returnType.getTypeSignature(), Lists.transform(argumentTypes, Type::getTypeSignature)), type);
    }

    public ReflectionWindowFunctionSupplier(Signature signature, Class<T> type) {
        super(signature, ReflectionWindowFunctionSupplier.getDescription(Objects.requireNonNull(type, "type is null")));
        try {
            ConstructorType constructorType;
            Constructor<T> constructor;
            if (signature.getArgumentTypes().isEmpty()) {
                constructor = type.getConstructor(new Class[0]);
                constructorType = ConstructorType.NO_INPUTS;
            } else if (ValueWindowFunction.class.isAssignableFrom(type)) {
                try {
                    constructor = type.getConstructor(List.class, Boolean.TYPE);
                    constructorType = ConstructorType.INPUTS_IGNORE_NULLS;
                }
                catch (NoSuchMethodException e) {
                    constructor = type.getConstructor(List.class);
                    constructorType = ConstructorType.INPUTS;
                }
            } else {
                constructor = type.getConstructor(List.class);
                constructorType = ConstructorType.INPUTS;
            }
            this.constructor = constructor;
            this.constructorType = constructorType;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected T newWindowFunction(List<Integer> inputs, boolean ignoreNulls) {
        try {
            switch (this.constructorType) {
                case NO_INPUTS: {
                    return (T)((WindowFunction)this.constructor.newInstance(new Object[0]));
                }
                case INPUTS: {
                    return (T)((WindowFunction)this.constructor.newInstance(inputs));
                }
                case INPUTS_IGNORE_NULLS: {
                    return (T)((WindowFunction)this.constructor.newInstance(inputs, ignoreNulls));
                }
            }
            throw new VerifyException("Unhandled constructor type: " + (Object)((Object)this.constructorType));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getDescription(AnnotatedElement annotatedElement) {
        Description description = annotatedElement.getAnnotation(Description.class);
        return description == null ? null : description.value();
    }

    private static enum ConstructorType {
        NO_INPUTS,
        INPUTS,
        INPUTS_IGNORE_NULLS;

    }
}

