/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.Expression;
import java.util.List;
import java.util.Objects;

public class SortExpressionContext {
    private final Expression sortExpression;
    private final List<Expression> searchExpressions;

    public SortExpressionContext(Expression sortExpression, List<Expression> searchExpressions) {
        this.sortExpression = Objects.requireNonNull(sortExpression, "sortExpression cannot be null");
        this.searchExpressions = ImmutableList.copyOf(searchExpressions);
    }

    public Expression getSortExpression() {
        return this.sortExpression;
    }

    public List<Expression> getSearchExpressions() {
        return this.searchExpressions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortExpressionContext that = (SortExpressionContext)o;
        return Objects.equals(this.sortExpression, that.sortExpression) && Objects.equals(this.searchExpressions, that.searchExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.sortExpression, this.searchExpressions);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sortExpression", (Object)this.sortExpression).add("searchExpressions", this.searchExpressions).toString();
    }
}

