/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.iterative.rule;

import io.prestosql.matching.Captures;
import io.prestosql.matching.Pattern;
import io.prestosql.sql.planner.iterative.Rule;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.Patterns;
import io.prestosql.sql.planner.plan.ValuesNode;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Expression;
import java.util.Collections;

public class RemoveTrivialFilters
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode filterNode, Captures captures, Rule.Context context) {
        Expression predicate = filterNode.getPredicate();
        if (predicate.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
            return Rule.Result.ofPlanNode(filterNode.getSource());
        }
        if (predicate.equals((Object)BooleanLiteral.FALSE_LITERAL)) {
            return Rule.Result.ofPlanNode(new ValuesNode(context.getIdAllocator().getNextId(), filterNode.getOutputSymbols(), Collections.emptyList()));
        }
        return Rule.Result.empty();
    }
}

