/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.planprinter;

import io.prestosql.Session;
import io.prestosql.execution.TableInfo;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.metadata.TableProperties;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.function.Function;

public class TableInfoSupplier
implements Function<TableScanNode, TableInfo> {
    private final Metadata metadata;
    private final Session session;

    public TableInfoSupplier(Metadata metadata, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    @Override
    public TableInfo apply(TableScanNode node) {
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, node.getTable());
        TableProperties tableProperties = this.metadata.getTableProperties(this.session, node.getTable());
        return new TableInfo(tableMetadata.getQualifiedName(), tableProperties.getPredicate());
    }
}

