/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.sanity;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.ExpressionExtractor;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.TypeAnalyzer;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.sanity.PlanSanityChecker;
import io.prestosql.sql.tree.ArrayConstructor;
import io.prestosql.sql.tree.AtTimeZone;
import io.prestosql.sql.tree.CurrentPath;
import io.prestosql.sql.tree.CurrentUser;
import io.prestosql.sql.tree.DefaultExpressionTraversalVisitor;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Extract;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.TryExpression;

public final class SugarFreeChecker
implements PlanSanityChecker.Checker {
    private static final Visitor VISITOR = new Visitor();

    @Override
    public void validate(PlanNode planNode, Session session, Metadata metadata, TypeAnalyzer typeAnalyzer, TypeProvider types, WarningCollector warningCollector) {
        ExpressionExtractor.forEachExpression(planNode, SugarFreeChecker::validate);
    }

    private static void validate(Expression expression) {
        VISITOR.process((Node)expression, null);
    }

    private static class Visitor
    extends DefaultExpressionTraversalVisitor<Void, ImmutableList.Builder<Symbol>> {
        private Visitor() {
        }

        protected Void visitExtract(Extract node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitTryExpression(TryExpression node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitAtTimeZone(AtTimeZone node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentPath(CurrentPath node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitCurrentUser(CurrentUser node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitLikePredicate(LikePredicate node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        protected Void visitArrayConstructor(ArrayConstructor node, ImmutableList.Builder<Symbol> context) {
            throw Visitor.createIllegalNodeException((Node)node);
        }

        private static IllegalArgumentException createIllegalNodeException(Node node) {
            return new IllegalArgumentException(node.getClass().getSimpleName() + " should have been replaced with a function call");
        }
    }
}

