/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import com.google.common.collect.ImmutableMap;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.plugin.tpch.TpchConnectorFactory;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.MaterializedResult;
import io.prestosql.testing.assertions.Assert;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestHiddenColumns {
    private LocalQueryRunner runner;

    @BeforeClass
    public void setUp() {
        this.runner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);
        this.runner.createCatalog((String)SessionTestUtils.TEST_SESSION.getCatalog().get(), (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() {
        if (this.runner != null) {
            this.runner.close();
            this.runner = null;
        }
    }

    @Test
    public void testDescribeTable() {
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)SessionTestUtils.TEST_SESSION, (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"regionkey", "bigint", "", ""}).row(new Object[]{"name", "varchar(25)", "", ""}).row(new Object[]{"comment", "varchar(152)", "", ""}).build();
        Assert.assertEquals((Iterable)this.runner.execute("DESC REGION"), (Iterable)expected);
    }

    @Test
    public void testSimpleSelect() {
        Assert.assertEquals((Iterable)this.runner.execute("SELECT * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, * from REGION"), (Iterable)this.runner.execute("SELECT row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT *, row_number, * from REGION"), (Iterable)this.runner.execute("SELECT regionkey, name, comment, row_number, regionkey, name, comment from REGION"));
        Assert.assertEquals((Iterable)this.runner.execute("SELECT row_number, x.row_number from REGION x"), (Iterable)this.runner.execute("SELECT row_number, row_number from REGION"));
    }

    @Test
    public void testAliasedTableColumns() {
        Assert.assertEquals((Iterable)this.runner.execute("SELECT * FROM orders AS t (a, b, c, d, e, f, g, h, i)"), (Iterable)this.runner.execute("SELECT * FROM orders"));
    }
}

