/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.block;

import io.airlift.slice.Slice;
import io.prestosql.block.AbstractTestBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.Int96ArrayBlock;
import io.prestosql.spi.block.Int96ArrayBlockBuilder;
import io.prestosql.spi.block.VariableWidthBlockBuilder;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInt96ArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestInt96ArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestInt96ArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestInt96ArrayBlock.alternatingNullValues(TestInt96ArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestInt96ArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestInt96ArrayBlock.createTestValue(100);
        VariableWidthBlockBuilder emptyBlockBuilder = new VariableWidthBlockBuilder(null, 0, 0);
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestInt96ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestInt96ArrayBlock.createTestValue(100);
        TestInt96ArrayBlock.assertEstimatedDataSizeForStats(TestInt96ArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        long[] high = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
        int[] low = new int[]{0, 0, 1, 2, 3, 4};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestInt96ArrayBlock.testCompactBlock((Block)new Int96ArrayBlock(0, Optional.empty(), new long[0], new int[0]));
        TestInt96ArrayBlock.testCompactBlock((Block)new Int96ArrayBlock(valueIsNull.length, Optional.of(valueIsNull), high, low));
        TestInt96ArrayBlock.testIncompactBlock((Block)new Int96ArrayBlock(valueIsNull.length - 2, Optional.of(valueIsNull), high, low));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        BlockBuilder blockBuilder = TestInt96ArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        Int96ArrayBlockBuilder blockBuilder = new Int96ArrayBlockBuilder(null, expectedValues.length);
        TestInt96ArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeLong(expectedValue.getLong(0));
            blockBuilder.writeInt(expectedValue.getInt(8));
            blockBuilder.closeEntry();
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestInt96ArrayBlock.createExpectedValue(12);
        }
        return expectedValues;
    }

    @Override
    protected void assertPositionEquals(Block block, int position, Slice expectedBytes) {
        Assert.assertEquals((long)block.getLong(position, 0), (long)expectedBytes.getLong(0));
        Assert.assertEquals((int)block.getInt(position, 8), (int)expectedBytes.getInt(8));
    }

    @Override
    protected boolean isByteAccessSupported() {
        return false;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isAlignedLongAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

