/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.block;

import io.airlift.slice.Slice;
import io.prestosql.block.AbstractTestBlock;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.LongArrayBlock;
import io.prestosql.spi.block.LongArrayBlockBuilder;
import io.prestosql.spi.block.VariableWidthBlockBuilder;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLongArrayBlock
extends AbstractTestBlock {
    @Test
    public void test() {
        Slice[] expectedValues = TestLongArrayBlock.createTestValue(17);
        this.assertFixedWithValues(expectedValues);
        this.assertFixedWithValues(TestLongArrayBlock.alternatingNullValues(expectedValues));
    }

    @Test
    public void testCopyPositions() {
        Slice[] expectedValues = TestLongArrayBlock.alternatingNullValues(TestLongArrayBlock.createTestValue(17));
        BlockBuilder blockBuilder = TestLongArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlockFilteredPositions(expectedValues, blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), 0, 2, 4, 6, 7, 9, 10, 16);
    }

    @Test
    public void testLazyBlockBuilderInitialization() {
        Slice[] expectedValues = TestLongArrayBlock.createTestValue(100);
        VariableWidthBlockBuilder emptyBlockBuilder = new VariableWidthBlockBuilder(null, 0, 0);
        VariableWidthBlockBuilder blockBuilder = new VariableWidthBlockBuilder(null, expectedValues.length, 32 * expectedValues.length);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
        TestLongArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        Assert.assertTrue((blockBuilder.getSizeInBytes() > emptyBlockBuilder.getSizeInBytes() ? 1 : 0) != 0);
        Assert.assertTrue((blockBuilder.getRetainedSizeInBytes() > emptyBlockBuilder.getRetainedSizeInBytes() ? 1 : 0) != 0);
        blockBuilder = blockBuilder.newBlockBuilderLike(null);
        Assert.assertEquals((long)blockBuilder.getSizeInBytes(), (long)emptyBlockBuilder.getSizeInBytes());
        Assert.assertEquals((long)blockBuilder.getRetainedSizeInBytes(), (long)emptyBlockBuilder.getRetainedSizeInBytes());
    }

    @Test
    public void testEstimatedDataSizeForStats() {
        Slice[] expectedValues = TestLongArrayBlock.createTestValue(100);
        TestLongArrayBlock.assertEstimatedDataSizeForStats(TestLongArrayBlock.createBlockBuilderWithValues(expectedValues), expectedValues);
    }

    @Test
    public void testCompactBlock() {
        long[] longArray = new long[]{0L, 0L, 1L, 2L, 3L, 4L};
        boolean[] valueIsNull = new boolean[]{false, true, false, false, false, false};
        TestLongArrayBlock.testCompactBlock((Block)new LongArrayBlock(0, Optional.empty(), new long[0]));
        TestLongArrayBlock.testCompactBlock((Block)new LongArrayBlock(longArray.length, Optional.of(valueIsNull), longArray));
        TestLongArrayBlock.testIncompactBlock((Block)new LongArrayBlock(longArray.length - 1, Optional.of(valueIsNull), longArray));
    }

    private void assertFixedWithValues(Slice[] expectedValues) {
        BlockBuilder blockBuilder = TestLongArrayBlock.createBlockBuilderWithValues(expectedValues);
        this.assertBlock((Block)blockBuilder, () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
        this.assertBlock(blockBuilder.build(), () -> blockBuilder.newBlockBuilderLike(null), expectedValues);
    }

    private static BlockBuilder createBlockBuilderWithValues(Slice[] expectedValues) {
        LongArrayBlockBuilder blockBuilder = new LongArrayBlockBuilder(null, expectedValues.length);
        TestLongArrayBlock.writeValues(expectedValues, (BlockBuilder)blockBuilder);
        return blockBuilder;
    }

    private static void writeValues(Slice[] expectedValues, BlockBuilder blockBuilder) {
        for (Slice expectedValue : expectedValues) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            blockBuilder.writeLong(expectedValue.getLong(0)).closeEntry();
        }
    }

    private static Slice[] createTestValue(int positionCount) {
        Slice[] expectedValues = new Slice[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            expectedValues[position] = TestLongArrayBlock.createExpectedValue(8);
        }
        return expectedValues;
    }

    @Override
    protected boolean isByteAccessSupported() {
        return false;
    }

    @Override
    protected boolean isShortAccessSupported() {
        return false;
    }

    @Override
    protected boolean isIntAccessSupported() {
        return false;
    }

    @Override
    protected boolean isSliceAccessSupported() {
        return false;
    }
}

